/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.cloudsearch.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class DomainEndpointOptions {
    @Nullable
    private Boolean enforceHttps;
    @Nullable
    private String tlsSecurityPolicy;

    private DomainEndpointOptions() {
    }

    public Optional<Boolean> enforceHttps() {
        return Optional.ofNullable(this.enforceHttps);
    }

    public Optional<String> tlsSecurityPolicy() {
        return Optional.ofNullable(this.tlsSecurityPolicy);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DomainEndpointOptions defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Boolean enforceHttps;
        @Nullable
        private String tlsSecurityPolicy;

        public Builder() {
        }

        public Builder(DomainEndpointOptions defaults) {
            Objects.requireNonNull(defaults);
            this.enforceHttps = defaults.enforceHttps;
            this.tlsSecurityPolicy = defaults.tlsSecurityPolicy;
        }

        @CustomType.Setter
        public Builder enforceHttps(@Nullable Boolean enforceHttps) {
            this.enforceHttps = enforceHttps;
            return this;
        }

        @CustomType.Setter
        public Builder tlsSecurityPolicy(@Nullable String tlsSecurityPolicy) {
            this.tlsSecurityPolicy = tlsSecurityPolicy;
            return this;
        }

        public DomainEndpointOptions build() {
            DomainEndpointOptions o = new DomainEndpointOptions();
            o.enforceHttps = this.enforceHttps;
            o.tlsSecurityPolicy = this.tlsSecurityPolicy;
            return o;
        }
    }
}

