/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.cloudwatch.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class EventTargetRedshiftTarget {
    private String database;
    @Nullable
    private String dbUser;
    @Nullable
    private String secretsManagerArn;
    @Nullable
    private String sql;
    @Nullable
    private String statementName;
    @Nullable
    private Boolean withEvent;

    private EventTargetRedshiftTarget() {
    }

    public String database() {
        return this.database;
    }

    public Optional<String> dbUser() {
        return Optional.ofNullable(this.dbUser);
    }

    public Optional<String> secretsManagerArn() {
        return Optional.ofNullable(this.secretsManagerArn);
    }

    public Optional<String> sql() {
        return Optional.ofNullable(this.sql);
    }

    public Optional<String> statementName() {
        return Optional.ofNullable(this.statementName);
    }

    public Optional<Boolean> withEvent() {
        return Optional.ofNullable(this.withEvent);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(EventTargetRedshiftTarget defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String database;
        @Nullable
        private String dbUser;
        @Nullable
        private String secretsManagerArn;
        @Nullable
        private String sql;
        @Nullable
        private String statementName;
        @Nullable
        private Boolean withEvent;

        public Builder() {
        }

        public Builder(EventTargetRedshiftTarget defaults) {
            Objects.requireNonNull(defaults);
            this.database = defaults.database;
            this.dbUser = defaults.dbUser;
            this.secretsManagerArn = defaults.secretsManagerArn;
            this.sql = defaults.sql;
            this.statementName = defaults.statementName;
            this.withEvent = defaults.withEvent;
        }

        @CustomType.Setter
        public Builder database(String database) {
            this.database = Objects.requireNonNull(database);
            return this;
        }

        @CustomType.Setter
        public Builder dbUser(@Nullable String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        @CustomType.Setter
        public Builder secretsManagerArn(@Nullable String secretsManagerArn) {
            this.secretsManagerArn = secretsManagerArn;
            return this;
        }

        @CustomType.Setter
        public Builder sql(@Nullable String sql) {
            this.sql = sql;
            return this;
        }

        @CustomType.Setter
        public Builder statementName(@Nullable String statementName) {
            this.statementName = statementName;
            return this;
        }

        @CustomType.Setter
        public Builder withEvent(@Nullable Boolean withEvent) {
            this.withEvent = withEvent;
            return this;
        }

        public EventTargetRedshiftTarget build() {
            EventTargetRedshiftTarget o = new EventTargetRedshiftTarget();
            o.database = this.database;
            o.dbUser = this.dbUser;
            o.secretsManagerArn = this.secretsManagerArn;
            o.sql = this.sql;
            o.statementName = this.statementName;
            o.withEvent = this.withEvent;
            return o;
        }
    }
}

