/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.cloudwatch.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class EventTargetRetryPolicy {
    @Nullable
    private Integer maximumEventAgeInSeconds;
    @Nullable
    private Integer maximumRetryAttempts;

    private EventTargetRetryPolicy() {
    }

    public Optional<Integer> maximumEventAgeInSeconds() {
        return Optional.ofNullable(this.maximumEventAgeInSeconds);
    }

    public Optional<Integer> maximumRetryAttempts() {
        return Optional.ofNullable(this.maximumRetryAttempts);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(EventTargetRetryPolicy defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Integer maximumEventAgeInSeconds;
        @Nullable
        private Integer maximumRetryAttempts;

        public Builder() {
        }

        public Builder(EventTargetRetryPolicy defaults) {
            Objects.requireNonNull(defaults);
            this.maximumEventAgeInSeconds = defaults.maximumEventAgeInSeconds;
            this.maximumRetryAttempts = defaults.maximumRetryAttempts;
        }

        @CustomType.Setter
        public Builder maximumEventAgeInSeconds(@Nullable Integer maximumEventAgeInSeconds) {
            this.maximumEventAgeInSeconds = maximumEventAgeInSeconds;
            return this;
        }

        @CustomType.Setter
        public Builder maximumRetryAttempts(@Nullable Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
            return this;
        }

        public EventTargetRetryPolicy build() {
            EventTargetRetryPolicy o = new EventTargetRetryPolicy();
            o.maximumEventAgeInSeconds = this.maximumEventAgeInSeconds;
            o.maximumRetryAttempts = this.maximumRetryAttempts;
            return o;
        }
    }
}

