/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.cloudwatch.outputs;

import com.pulumi.aws.cloudwatch.outputs.MetricStreamStatisticsConfigurationIncludeMetric;
import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;

@CustomType
public final class MetricStreamStatisticsConfiguration {
    private List<String> additionalStatistics;
    private List<MetricStreamStatisticsConfigurationIncludeMetric> includeMetrics;

    private MetricStreamStatisticsConfiguration() {
    }

    public List<String> additionalStatistics() {
        return this.additionalStatistics;
    }

    public List<MetricStreamStatisticsConfigurationIncludeMetric> includeMetrics() {
        return this.includeMetrics;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MetricStreamStatisticsConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private List<String> additionalStatistics;
        private List<MetricStreamStatisticsConfigurationIncludeMetric> includeMetrics;

        public Builder() {
        }

        public Builder(MetricStreamStatisticsConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.additionalStatistics = defaults.additionalStatistics;
            this.includeMetrics = defaults.includeMetrics;
        }

        @CustomType.Setter
        public Builder additionalStatistics(List<String> additionalStatistics) {
            this.additionalStatistics = Objects.requireNonNull(additionalStatistics);
            return this;
        }

        public Builder additionalStatistics(String ... additionalStatistics) {
            return this.additionalStatistics(List.of(additionalStatistics));
        }

        @CustomType.Setter
        public Builder includeMetrics(List<MetricStreamStatisticsConfigurationIncludeMetric> includeMetrics) {
            this.includeMetrics = Objects.requireNonNull(includeMetrics);
            return this;
        }

        public Builder includeMetrics(MetricStreamStatisticsConfigurationIncludeMetric ... includeMetrics) {
            return this.includeMetrics(List.of(includeMetrics));
        }

        public MetricStreamStatisticsConfiguration build() {
            MetricStreamStatisticsConfiguration o = new MetricStreamStatisticsConfiguration();
            o.additionalStatistics = this.additionalStatistics;
            o.includeMetrics = this.includeMetrics;
            return o;
        }
    }
}

