/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.codebuild;

import com.pulumi.aws.codebuild.inputs.ProjectArtifactsArgs;
import com.pulumi.aws.codebuild.inputs.ProjectBuildBatchConfigArgs;
import com.pulumi.aws.codebuild.inputs.ProjectCacheArgs;
import com.pulumi.aws.codebuild.inputs.ProjectEnvironmentArgs;
import com.pulumi.aws.codebuild.inputs.ProjectFileSystemLocationArgs;
import com.pulumi.aws.codebuild.inputs.ProjectLogsConfigArgs;
import com.pulumi.aws.codebuild.inputs.ProjectSecondaryArtifactArgs;
import com.pulumi.aws.codebuild.inputs.ProjectSecondarySourceArgs;
import com.pulumi.aws.codebuild.inputs.ProjectSecondarySourceVersionArgs;
import com.pulumi.aws.codebuild.inputs.ProjectSourceArgs;
import com.pulumi.aws.codebuild.inputs.ProjectVpcConfigArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.resources.ResourceArgs;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ProjectArgs
extends ResourceArgs {
    public static final ProjectArgs Empty = new ProjectArgs();
    @Import(name="artifacts", required=true)
    private Output<ProjectArtifactsArgs> artifacts;
    @Import(name="badgeEnabled")
    @Nullable
    private Output<Boolean> badgeEnabled;
    @Import(name="buildBatchConfig")
    @Nullable
    private Output<ProjectBuildBatchConfigArgs> buildBatchConfig;
    @Import(name="buildTimeout")
    @Nullable
    private Output<Integer> buildTimeout;
    @Import(name="cache")
    @Nullable
    private Output<ProjectCacheArgs> cache;
    @Import(name="concurrentBuildLimit")
    @Nullable
    private Output<Integer> concurrentBuildLimit;
    @Import(name="description")
    @Nullable
    private Output<String> description;
    @Import(name="encryptionKey")
    @Nullable
    private Output<String> encryptionKey;
    @Import(name="environment", required=true)
    private Output<ProjectEnvironmentArgs> environment;
    @Import(name="fileSystemLocations")
    @Nullable
    private Output<List<ProjectFileSystemLocationArgs>> fileSystemLocations;
    @Import(name="logsConfig")
    @Nullable
    private Output<ProjectLogsConfigArgs> logsConfig;
    @Import(name="name")
    @Nullable
    private Output<String> name;
    @Import(name="projectVisibility")
    @Nullable
    private Output<String> projectVisibility;
    @Import(name="queuedTimeout")
    @Nullable
    private Output<Integer> queuedTimeout;
    @Import(name="resourceAccessRole")
    @Nullable
    private Output<String> resourceAccessRole;
    @Import(name="secondaryArtifacts")
    @Nullable
    private Output<List<ProjectSecondaryArtifactArgs>> secondaryArtifacts;
    @Import(name="secondarySourceVersions")
    @Nullable
    private Output<List<ProjectSecondarySourceVersionArgs>> secondarySourceVersions;
    @Import(name="secondarySources")
    @Nullable
    private Output<List<ProjectSecondarySourceArgs>> secondarySources;
    @Import(name="serviceRole", required=true)
    private Output<String> serviceRole;
    @Import(name="source", required=true)
    private Output<ProjectSourceArgs> source;
    @Import(name="sourceVersion")
    @Nullable
    private Output<String> sourceVersion;
    @Import(name="tags")
    @Nullable
    private Output<Map<String, String>> tags;
    @Import(name="vpcConfig")
    @Nullable
    private Output<ProjectVpcConfigArgs> vpcConfig;

    public Output<ProjectArtifactsArgs> artifacts() {
        return this.artifacts;
    }

    public Optional<Output<Boolean>> badgeEnabled() {
        return Optional.ofNullable(this.badgeEnabled);
    }

    public Optional<Output<ProjectBuildBatchConfigArgs>> buildBatchConfig() {
        return Optional.ofNullable(this.buildBatchConfig);
    }

    public Optional<Output<Integer>> buildTimeout() {
        return Optional.ofNullable(this.buildTimeout);
    }

    public Optional<Output<ProjectCacheArgs>> cache() {
        return Optional.ofNullable(this.cache);
    }

    public Optional<Output<Integer>> concurrentBuildLimit() {
        return Optional.ofNullable(this.concurrentBuildLimit);
    }

    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    public Optional<Output<String>> encryptionKey() {
        return Optional.ofNullable(this.encryptionKey);
    }

    public Output<ProjectEnvironmentArgs> environment() {
        return this.environment;
    }

    public Optional<Output<List<ProjectFileSystemLocationArgs>>> fileSystemLocations() {
        return Optional.ofNullable(this.fileSystemLocations);
    }

    public Optional<Output<ProjectLogsConfigArgs>> logsConfig() {
        return Optional.ofNullable(this.logsConfig);
    }

    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    public Optional<Output<String>> projectVisibility() {
        return Optional.ofNullable(this.projectVisibility);
    }

    public Optional<Output<Integer>> queuedTimeout() {
        return Optional.ofNullable(this.queuedTimeout);
    }

    public Optional<Output<String>> resourceAccessRole() {
        return Optional.ofNullable(this.resourceAccessRole);
    }

    public Optional<Output<List<ProjectSecondaryArtifactArgs>>> secondaryArtifacts() {
        return Optional.ofNullable(this.secondaryArtifacts);
    }

    public Optional<Output<List<ProjectSecondarySourceVersionArgs>>> secondarySourceVersions() {
        return Optional.ofNullable(this.secondarySourceVersions);
    }

    public Optional<Output<List<ProjectSecondarySourceArgs>>> secondarySources() {
        return Optional.ofNullable(this.secondarySources);
    }

    public Output<String> serviceRole() {
        return this.serviceRole;
    }

    public Output<ProjectSourceArgs> source() {
        return this.source;
    }

    public Optional<Output<String>> sourceVersion() {
        return Optional.ofNullable(this.sourceVersion);
    }

    public Optional<Output<Map<String, String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    public Optional<Output<ProjectVpcConfigArgs>> vpcConfig() {
        return Optional.ofNullable(this.vpcConfig);
    }

    private ProjectArgs() {
    }

    private ProjectArgs(ProjectArgs $) {
        this.artifacts = $.artifacts;
        this.badgeEnabled = $.badgeEnabled;
        this.buildBatchConfig = $.buildBatchConfig;
        this.buildTimeout = $.buildTimeout;
        this.cache = $.cache;
        this.concurrentBuildLimit = $.concurrentBuildLimit;
        this.description = $.description;
        this.encryptionKey = $.encryptionKey;
        this.environment = $.environment;
        this.fileSystemLocations = $.fileSystemLocations;
        this.logsConfig = $.logsConfig;
        this.name = $.name;
        this.projectVisibility = $.projectVisibility;
        this.queuedTimeout = $.queuedTimeout;
        this.resourceAccessRole = $.resourceAccessRole;
        this.secondaryArtifacts = $.secondaryArtifacts;
        this.secondarySourceVersions = $.secondarySourceVersions;
        this.secondarySources = $.secondarySources;
        this.serviceRole = $.serviceRole;
        this.source = $.source;
        this.sourceVersion = $.sourceVersion;
        this.tags = $.tags;
        this.vpcConfig = $.vpcConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ProjectArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ProjectArgs $;

        public Builder() {
            this.$ = new ProjectArgs();
        }

        public Builder(ProjectArgs defaults) {
            this.$ = new ProjectArgs(Objects.requireNonNull(defaults));
        }

        public Builder artifacts(Output<ProjectArtifactsArgs> artifacts) {
            this.$.artifacts = artifacts;
            return this;
        }

        public Builder artifacts(ProjectArtifactsArgs artifacts) {
            return this.artifacts((Output<ProjectArtifactsArgs>)Output.of((Object)((Object)artifacts)));
        }

        public Builder badgeEnabled(@Nullable Output<Boolean> badgeEnabled) {
            this.$.badgeEnabled = badgeEnabled;
            return this;
        }

        public Builder badgeEnabled(Boolean badgeEnabled) {
            return this.badgeEnabled((Output<Boolean>)Output.of((Object)badgeEnabled));
        }

        public Builder buildBatchConfig(@Nullable Output<ProjectBuildBatchConfigArgs> buildBatchConfig) {
            this.$.buildBatchConfig = buildBatchConfig;
            return this;
        }

        public Builder buildBatchConfig(ProjectBuildBatchConfigArgs buildBatchConfig) {
            return this.buildBatchConfig((Output<ProjectBuildBatchConfigArgs>)Output.of((Object)((Object)buildBatchConfig)));
        }

        public Builder buildTimeout(@Nullable Output<Integer> buildTimeout) {
            this.$.buildTimeout = buildTimeout;
            return this;
        }

        public Builder buildTimeout(Integer buildTimeout) {
            return this.buildTimeout((Output<Integer>)Output.of((Object)buildTimeout));
        }

        public Builder cache(@Nullable Output<ProjectCacheArgs> cache) {
            this.$.cache = cache;
            return this;
        }

        public Builder cache(ProjectCacheArgs cache) {
            return this.cache((Output<ProjectCacheArgs>)Output.of((Object)((Object)cache)));
        }

        public Builder concurrentBuildLimit(@Nullable Output<Integer> concurrentBuildLimit) {
            this.$.concurrentBuildLimit = concurrentBuildLimit;
            return this;
        }

        public Builder concurrentBuildLimit(Integer concurrentBuildLimit) {
            return this.concurrentBuildLimit((Output<Integer>)Output.of((Object)concurrentBuildLimit));
        }

        public Builder description(@Nullable Output<String> description) {
            this.$.description = description;
            return this;
        }

        public Builder description(String description) {
            return this.description((Output<String>)Output.of((Object)description));
        }

        public Builder encryptionKey(@Nullable Output<String> encryptionKey) {
            this.$.encryptionKey = encryptionKey;
            return this;
        }

        public Builder encryptionKey(String encryptionKey) {
            return this.encryptionKey((Output<String>)Output.of((Object)encryptionKey));
        }

        public Builder environment(Output<ProjectEnvironmentArgs> environment) {
            this.$.environment = environment;
            return this;
        }

        public Builder environment(ProjectEnvironmentArgs environment) {
            return this.environment((Output<ProjectEnvironmentArgs>)Output.of((Object)((Object)environment)));
        }

        public Builder fileSystemLocations(@Nullable Output<List<ProjectFileSystemLocationArgs>> fileSystemLocations) {
            this.$.fileSystemLocations = fileSystemLocations;
            return this;
        }

        public Builder fileSystemLocations(List<ProjectFileSystemLocationArgs> fileSystemLocations) {
            return this.fileSystemLocations((Output<List<ProjectFileSystemLocationArgs>>)Output.of(fileSystemLocations));
        }

        public Builder fileSystemLocations(ProjectFileSystemLocationArgs ... fileSystemLocations) {
            return this.fileSystemLocations(List.of(fileSystemLocations));
        }

        public Builder logsConfig(@Nullable Output<ProjectLogsConfigArgs> logsConfig) {
            this.$.logsConfig = logsConfig;
            return this;
        }

        public Builder logsConfig(ProjectLogsConfigArgs logsConfig) {
            return this.logsConfig((Output<ProjectLogsConfigArgs>)Output.of((Object)((Object)logsConfig)));
        }

        public Builder name(@Nullable Output<String> name) {
            this.$.name = name;
            return this;
        }

        public Builder name(String name) {
            return this.name((Output<String>)Output.of((Object)name));
        }

        public Builder projectVisibility(@Nullable Output<String> projectVisibility) {
            this.$.projectVisibility = projectVisibility;
            return this;
        }

        public Builder projectVisibility(String projectVisibility) {
            return this.projectVisibility((Output<String>)Output.of((Object)projectVisibility));
        }

        public Builder queuedTimeout(@Nullable Output<Integer> queuedTimeout) {
            this.$.queuedTimeout = queuedTimeout;
            return this;
        }

        public Builder queuedTimeout(Integer queuedTimeout) {
            return this.queuedTimeout((Output<Integer>)Output.of((Object)queuedTimeout));
        }

        public Builder resourceAccessRole(@Nullable Output<String> resourceAccessRole) {
            this.$.resourceAccessRole = resourceAccessRole;
            return this;
        }

        public Builder resourceAccessRole(String resourceAccessRole) {
            return this.resourceAccessRole((Output<String>)Output.of((Object)resourceAccessRole));
        }

        public Builder secondaryArtifacts(@Nullable Output<List<ProjectSecondaryArtifactArgs>> secondaryArtifacts) {
            this.$.secondaryArtifacts = secondaryArtifacts;
            return this;
        }

        public Builder secondaryArtifacts(List<ProjectSecondaryArtifactArgs> secondaryArtifacts) {
            return this.secondaryArtifacts((Output<List<ProjectSecondaryArtifactArgs>>)Output.of(secondaryArtifacts));
        }

        public Builder secondaryArtifacts(ProjectSecondaryArtifactArgs ... secondaryArtifacts) {
            return this.secondaryArtifacts(List.of(secondaryArtifacts));
        }

        public Builder secondarySourceVersions(@Nullable Output<List<ProjectSecondarySourceVersionArgs>> secondarySourceVersions) {
            this.$.secondarySourceVersions = secondarySourceVersions;
            return this;
        }

        public Builder secondarySourceVersions(List<ProjectSecondarySourceVersionArgs> secondarySourceVersions) {
            return this.secondarySourceVersions((Output<List<ProjectSecondarySourceVersionArgs>>)Output.of(secondarySourceVersions));
        }

        public Builder secondarySourceVersions(ProjectSecondarySourceVersionArgs ... secondarySourceVersions) {
            return this.secondarySourceVersions(List.of(secondarySourceVersions));
        }

        public Builder secondarySources(@Nullable Output<List<ProjectSecondarySourceArgs>> secondarySources) {
            this.$.secondarySources = secondarySources;
            return this;
        }

        public Builder secondarySources(List<ProjectSecondarySourceArgs> secondarySources) {
            return this.secondarySources((Output<List<ProjectSecondarySourceArgs>>)Output.of(secondarySources));
        }

        public Builder secondarySources(ProjectSecondarySourceArgs ... secondarySources) {
            return this.secondarySources(List.of(secondarySources));
        }

        public Builder serviceRole(Output<String> serviceRole) {
            this.$.serviceRole = serviceRole;
            return this;
        }

        public Builder serviceRole(String serviceRole) {
            return this.serviceRole((Output<String>)Output.of((Object)serviceRole));
        }

        public Builder source(Output<ProjectSourceArgs> source) {
            this.$.source = source;
            return this;
        }

        public Builder source(ProjectSourceArgs source) {
            return this.source((Output<ProjectSourceArgs>)Output.of((Object)((Object)source)));
        }

        public Builder sourceVersion(@Nullable Output<String> sourceVersion) {
            this.$.sourceVersion = sourceVersion;
            return this;
        }

        public Builder sourceVersion(String sourceVersion) {
            return this.sourceVersion((Output<String>)Output.of((Object)sourceVersion));
        }

        public Builder tags(@Nullable Output<Map<String, String>> tags) {
            this.$.tags = tags;
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            return this.tags((Output<Map<String, String>>)Output.of(tags));
        }

        public Builder vpcConfig(@Nullable Output<ProjectVpcConfigArgs> vpcConfig) {
            this.$.vpcConfig = vpcConfig;
            return this;
        }

        public Builder vpcConfig(ProjectVpcConfigArgs vpcConfig) {
            return this.vpcConfig((Output<ProjectVpcConfigArgs>)Output.of((Object)((Object)vpcConfig)));
        }

        public ProjectArgs build() {
            this.$.artifacts = Objects.requireNonNull(this.$.artifacts, "expected parameter 'artifacts' to be non-null");
            this.$.environment = Objects.requireNonNull(this.$.environment, "expected parameter 'environment' to be non-null");
            this.$.serviceRole = Objects.requireNonNull(this.$.serviceRole, "expected parameter 'serviceRole' to be non-null");
            this.$.source = Objects.requireNonNull(this.$.source, "expected parameter 'source' to be non-null");
            return this.$;
        }
    }
}

