/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.codebuild;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.resources.ResourceArgs;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class SourceCredentialArgs
extends ResourceArgs {
    public static final SourceCredentialArgs Empty = new SourceCredentialArgs();
    @Import(name="authType", required=true)
    private Output<String> authType;
    @Import(name="serverType", required=true)
    private Output<String> serverType;
    @Import(name="token", required=true)
    private Output<String> token;
    @Import(name="userName")
    @Nullable
    private Output<String> userName;

    public Output<String> authType() {
        return this.authType;
    }

    public Output<String> serverType() {
        return this.serverType;
    }

    public Output<String> token() {
        return this.token;
    }

    public Optional<Output<String>> userName() {
        return Optional.ofNullable(this.userName);
    }

    private SourceCredentialArgs() {
    }

    private SourceCredentialArgs(SourceCredentialArgs $) {
        this.authType = $.authType;
        this.serverType = $.serverType;
        this.token = $.token;
        this.userName = $.userName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SourceCredentialArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private SourceCredentialArgs $;

        public Builder() {
            this.$ = new SourceCredentialArgs();
        }

        public Builder(SourceCredentialArgs defaults) {
            this.$ = new SourceCredentialArgs(Objects.requireNonNull(defaults));
        }

        public Builder authType(Output<String> authType) {
            this.$.authType = authType;
            return this;
        }

        public Builder authType(String authType) {
            return this.authType((Output<String>)Output.of((Object)authType));
        }

        public Builder serverType(Output<String> serverType) {
            this.$.serverType = serverType;
            return this;
        }

        public Builder serverType(String serverType) {
            return this.serverType((Output<String>)Output.of((Object)serverType));
        }

        public Builder token(Output<String> token) {
            this.$.token = token;
            return this;
        }

        public Builder token(String token) {
            return this.token((Output<String>)Output.of((Object)token));
        }

        public Builder userName(@Nullable Output<String> userName) {
            this.$.userName = userName;
            return this;
        }

        public Builder userName(String userName) {
            return this.userName((Output<String>)Output.of((Object)userName));
        }

        public SourceCredentialArgs build() {
            this.$.authType = Objects.requireNonNull(this.$.authType, "expected parameter 'authType' to be non-null");
            this.$.serverType = Objects.requireNonNull(this.$.serverType, "expected parameter 'serverType' to be non-null");
            this.$.token = Objects.requireNonNull(this.$.token, "expected parameter 'token' to be non-null");
            return this.$;
        }
    }
}

