/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.codebuild.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ProjectFileSystemLocation {
    @Nullable
    private String identifier;
    @Nullable
    private String location;
    @Nullable
    private String mountOptions;
    @Nullable
    private String mountPoint;
    @Nullable
    private String type;

    private ProjectFileSystemLocation() {
    }

    public Optional<String> identifier() {
        return Optional.ofNullable(this.identifier);
    }

    public Optional<String> location() {
        return Optional.ofNullable(this.location);
    }

    public Optional<String> mountOptions() {
        return Optional.ofNullable(this.mountOptions);
    }

    public Optional<String> mountPoint() {
        return Optional.ofNullable(this.mountPoint);
    }

    public Optional<String> type() {
        return Optional.ofNullable(this.type);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ProjectFileSystemLocation defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String identifier;
        @Nullable
        private String location;
        @Nullable
        private String mountOptions;
        @Nullable
        private String mountPoint;
        @Nullable
        private String type;

        public Builder() {
        }

        public Builder(ProjectFileSystemLocation defaults) {
            Objects.requireNonNull(defaults);
            this.identifier = defaults.identifier;
            this.location = defaults.location;
            this.mountOptions = defaults.mountOptions;
            this.mountPoint = defaults.mountPoint;
            this.type = defaults.type;
        }

        @CustomType.Setter
        public Builder identifier(@Nullable String identifier) {
            this.identifier = identifier;
            return this;
        }

        @CustomType.Setter
        public Builder location(@Nullable String location) {
            this.location = location;
            return this;
        }

        @CustomType.Setter
        public Builder mountOptions(@Nullable String mountOptions) {
            this.mountOptions = mountOptions;
            return this;
        }

        @CustomType.Setter
        public Builder mountPoint(@Nullable String mountPoint) {
            this.mountPoint = mountPoint;
            return this;
        }

        @CustomType.Setter
        public Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        public ProjectFileSystemLocation build() {
            ProjectFileSystemLocation o = new ProjectFileSystemLocation();
            o.identifier = this.identifier;
            o.location = this.location;
            o.mountOptions = this.mountOptions;
            o.mountPoint = this.mountPoint;
            o.type = this.type;
            return o;
        }
    }
}

