/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.codebuild.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;

@CustomType
public final class ProjectVpcConfig {
    private List<String> securityGroupIds;
    private List<String> subnets;
    private String vpcId;

    private ProjectVpcConfig() {
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public List<String> subnets() {
        return this.subnets;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ProjectVpcConfig defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private List<String> securityGroupIds;
        private List<String> subnets;
        private String vpcId;

        public Builder() {
        }

        public Builder(ProjectVpcConfig defaults) {
            Objects.requireNonNull(defaults);
            this.securityGroupIds = defaults.securityGroupIds;
            this.subnets = defaults.subnets;
            this.vpcId = defaults.vpcId;
        }

        @CustomType.Setter
        public Builder securityGroupIds(List<String> securityGroupIds) {
            this.securityGroupIds = Objects.requireNonNull(securityGroupIds);
            return this;
        }

        public Builder securityGroupIds(String ... securityGroupIds) {
            return this.securityGroupIds(List.of(securityGroupIds));
        }

        @CustomType.Setter
        public Builder subnets(List<String> subnets) {
            this.subnets = Objects.requireNonNull(subnets);
            return this;
        }

        public Builder subnets(String ... subnets) {
            return this.subnets(List.of(subnets));
        }

        @CustomType.Setter
        public Builder vpcId(String vpcId) {
            this.vpcId = Objects.requireNonNull(vpcId);
            return this;
        }

        public ProjectVpcConfig build() {
            ProjectVpcConfig o = new ProjectVpcConfig();
            o.securityGroupIds = this.securityGroupIds;
            o.subnets = this.subnets;
            o.vpcId = this.vpcId;
            return o;
        }
    }
}

