/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.codepipeline;

import com.pulumi.aws.codepipeline.inputs.WebhookAuthenticationConfigurationArgs;
import com.pulumi.aws.codepipeline.inputs.WebhookFilterArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.resources.ResourceArgs;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class WebhookArgs
extends ResourceArgs {
    public static final WebhookArgs Empty = new WebhookArgs();
    @Import(name="authentication", required=true)
    private Output<String> authentication;
    @Import(name="authenticationConfiguration")
    @Nullable
    private Output<WebhookAuthenticationConfigurationArgs> authenticationConfiguration;
    @Import(name="filters", required=true)
    private Output<List<WebhookFilterArgs>> filters;
    @Import(name="name")
    @Nullable
    private Output<String> name;
    @Import(name="tags")
    @Nullable
    private Output<Map<String, String>> tags;
    @Import(name="targetAction", required=true)
    private Output<String> targetAction;
    @Import(name="targetPipeline", required=true)
    private Output<String> targetPipeline;

    public Output<String> authentication() {
        return this.authentication;
    }

    public Optional<Output<WebhookAuthenticationConfigurationArgs>> authenticationConfiguration() {
        return Optional.ofNullable(this.authenticationConfiguration);
    }

    public Output<List<WebhookFilterArgs>> filters() {
        return this.filters;
    }

    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    public Optional<Output<Map<String, String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    public Output<String> targetAction() {
        return this.targetAction;
    }

    public Output<String> targetPipeline() {
        return this.targetPipeline;
    }

    private WebhookArgs() {
    }

    private WebhookArgs(WebhookArgs $) {
        this.authentication = $.authentication;
        this.authenticationConfiguration = $.authenticationConfiguration;
        this.filters = $.filters;
        this.name = $.name;
        this.tags = $.tags;
        this.targetAction = $.targetAction;
        this.targetPipeline = $.targetPipeline;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(WebhookArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private WebhookArgs $;

        public Builder() {
            this.$ = new WebhookArgs();
        }

        public Builder(WebhookArgs defaults) {
            this.$ = new WebhookArgs(Objects.requireNonNull(defaults));
        }

        public Builder authentication(Output<String> authentication) {
            this.$.authentication = authentication;
            return this;
        }

        public Builder authentication(String authentication) {
            return this.authentication((Output<String>)Output.of((Object)authentication));
        }

        public Builder authenticationConfiguration(@Nullable Output<WebhookAuthenticationConfigurationArgs> authenticationConfiguration) {
            this.$.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        public Builder authenticationConfiguration(WebhookAuthenticationConfigurationArgs authenticationConfiguration) {
            return this.authenticationConfiguration((Output<WebhookAuthenticationConfigurationArgs>)Output.of((Object)((Object)authenticationConfiguration)));
        }

        public Builder filters(Output<List<WebhookFilterArgs>> filters) {
            this.$.filters = filters;
            return this;
        }

        public Builder filters(List<WebhookFilterArgs> filters) {
            return this.filters((Output<List<WebhookFilterArgs>>)Output.of(filters));
        }

        public Builder filters(WebhookFilterArgs ... filters) {
            return this.filters(List.of(filters));
        }

        public Builder name(@Nullable Output<String> name) {
            this.$.name = name;
            return this;
        }

        public Builder name(String name) {
            return this.name((Output<String>)Output.of((Object)name));
        }

        public Builder tags(@Nullable Output<Map<String, String>> tags) {
            this.$.tags = tags;
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            return this.tags((Output<Map<String, String>>)Output.of(tags));
        }

        public Builder targetAction(Output<String> targetAction) {
            this.$.targetAction = targetAction;
            return this;
        }

        public Builder targetAction(String targetAction) {
            return this.targetAction((Output<String>)Output.of((Object)targetAction));
        }

        public Builder targetPipeline(Output<String> targetPipeline) {
            this.$.targetPipeline = targetPipeline;
            return this;
        }

        public Builder targetPipeline(String targetPipeline) {
            return this.targetPipeline((Output<String>)Output.of((Object)targetPipeline));
        }

        public WebhookArgs build() {
            this.$.authentication = Objects.requireNonNull(this.$.authentication, "expected parameter 'authentication' to be non-null");
            this.$.filters = Objects.requireNonNull(this.$.filters, "expected parameter 'filters' to be non-null");
            this.$.targetAction = Objects.requireNonNull(this.$.targetAction, "expected parameter 'targetAction' to be non-null");
            this.$.targetPipeline = Objects.requireNonNull(this.$.targetPipeline, "expected parameter 'targetPipeline' to be non-null");
            return this.$;
        }
    }
}

