/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.codepipeline.outputs;

import com.pulumi.aws.codepipeline.outputs.PipelineStageAction;
import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;

@CustomType
public final class PipelineStage {
    private List<PipelineStageAction> actions;
    private String name;

    private PipelineStage() {
    }

    public List<PipelineStageAction> actions() {
        return this.actions;
    }

    public String name() {
        return this.name;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PipelineStage defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private List<PipelineStageAction> actions;
        private String name;

        public Builder() {
        }

        public Builder(PipelineStage defaults) {
            Objects.requireNonNull(defaults);
            this.actions = defaults.actions;
            this.name = defaults.name;
        }

        @CustomType.Setter
        public Builder actions(List<PipelineStageAction> actions) {
            this.actions = Objects.requireNonNull(actions);
            return this;
        }

        public Builder actions(PipelineStageAction ... actions) {
            return this.actions(List.of(actions));
        }

        @CustomType.Setter
        public Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        public PipelineStage build() {
            PipelineStage o = new PipelineStage();
            o.actions = this.actions;
            o.name = this.name;
            return o;
        }
    }
}

