/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.codepipeline.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class WebhookAuthenticationConfiguration {
    @Nullable
    private String allowedIpRange;
    @Nullable
    private String secretToken;

    private WebhookAuthenticationConfiguration() {
    }

    public Optional<String> allowedIpRange() {
        return Optional.ofNullable(this.allowedIpRange);
    }

    public Optional<String> secretToken() {
        return Optional.ofNullable(this.secretToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(WebhookAuthenticationConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String allowedIpRange;
        @Nullable
        private String secretToken;

        public Builder() {
        }

        public Builder(WebhookAuthenticationConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.allowedIpRange = defaults.allowedIpRange;
            this.secretToken = defaults.secretToken;
        }

        @CustomType.Setter
        public Builder allowedIpRange(@Nullable String allowedIpRange) {
            this.allowedIpRange = allowedIpRange;
            return this;
        }

        @CustomType.Setter
        public Builder secretToken(@Nullable String secretToken) {
            this.secretToken = secretToken;
            return this;
        }

        public WebhookAuthenticationConfiguration build() {
            WebhookAuthenticationConfiguration o = new WebhookAuthenticationConfiguration();
            o.allowedIpRange = this.allowedIpRange;
            o.secretToken = this.secretToken;
            return o;
        }
    }
}

