/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.codestarconnections.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class HostVpcConfiguration {
    private List<String> securityGroupIds;
    private List<String> subnetIds;
    @Nullable
    private String tlsCertificate;
    private String vpcId;

    private HostVpcConfiguration() {
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public Optional<String> tlsCertificate() {
        return Optional.ofNullable(this.tlsCertificate);
    }

    public String vpcId() {
        return this.vpcId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(HostVpcConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private List<String> securityGroupIds;
        private List<String> subnetIds;
        @Nullable
        private String tlsCertificate;
        private String vpcId;

        public Builder() {
        }

        public Builder(HostVpcConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.securityGroupIds = defaults.securityGroupIds;
            this.subnetIds = defaults.subnetIds;
            this.tlsCertificate = defaults.tlsCertificate;
            this.vpcId = defaults.vpcId;
        }

        @CustomType.Setter
        public Builder securityGroupIds(List<String> securityGroupIds) {
            this.securityGroupIds = Objects.requireNonNull(securityGroupIds);
            return this;
        }

        public Builder securityGroupIds(String ... securityGroupIds) {
            return this.securityGroupIds(List.of(securityGroupIds));
        }

        @CustomType.Setter
        public Builder subnetIds(List<String> subnetIds) {
            this.subnetIds = Objects.requireNonNull(subnetIds);
            return this;
        }

        public Builder subnetIds(String ... subnetIds) {
            return this.subnetIds(List.of(subnetIds));
        }

        @CustomType.Setter
        public Builder tlsCertificate(@Nullable String tlsCertificate) {
            this.tlsCertificate = tlsCertificate;
            return this;
        }

        @CustomType.Setter
        public Builder vpcId(String vpcId) {
            this.vpcId = Objects.requireNonNull(vpcId);
            return this;
        }

        public HostVpcConfiguration build() {
            HostVpcConfiguration o = new HostVpcConfiguration();
            o.securityGroupIds = this.securityGroupIds;
            o.subnetIds = this.subnetIds;
            o.tlsCertificate = this.tlsCertificate;
            o.vpcId = this.vpcId;
            return o;
        }
    }
}

