/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.cognito.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class UserPoolDeviceConfiguration {
    @Nullable
    private Boolean challengeRequiredOnNewDevice;
    @Nullable
    private Boolean deviceOnlyRememberedOnUserPrompt;

    private UserPoolDeviceConfiguration() {
    }

    public Optional<Boolean> challengeRequiredOnNewDevice() {
        return Optional.ofNullable(this.challengeRequiredOnNewDevice);
    }

    public Optional<Boolean> deviceOnlyRememberedOnUserPrompt() {
        return Optional.ofNullable(this.deviceOnlyRememberedOnUserPrompt);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(UserPoolDeviceConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Boolean challengeRequiredOnNewDevice;
        @Nullable
        private Boolean deviceOnlyRememberedOnUserPrompt;

        public Builder() {
        }

        public Builder(UserPoolDeviceConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.challengeRequiredOnNewDevice = defaults.challengeRequiredOnNewDevice;
            this.deviceOnlyRememberedOnUserPrompt = defaults.deviceOnlyRememberedOnUserPrompt;
        }

        @CustomType.Setter
        public Builder challengeRequiredOnNewDevice(@Nullable Boolean challengeRequiredOnNewDevice) {
            this.challengeRequiredOnNewDevice = challengeRequiredOnNewDevice;
            return this;
        }

        @CustomType.Setter
        public Builder deviceOnlyRememberedOnUserPrompt(@Nullable Boolean deviceOnlyRememberedOnUserPrompt) {
            this.deviceOnlyRememberedOnUserPrompt = deviceOnlyRememberedOnUserPrompt;
            return this;
        }

        public UserPoolDeviceConfiguration build() {
            UserPoolDeviceConfiguration o = new UserPoolDeviceConfiguration();
            o.challengeRequiredOnNewDevice = this.challengeRequiredOnNewDevice;
            o.deviceOnlyRememberedOnUserPrompt = this.deviceOnlyRememberedOnUserPrompt;
            return o;
        }
    }
}

