/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.directoryservice.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@CustomType
public final class DirectoryVpcSettings {
    @Nullable
    private List<String> availabilityZones;
    private List<String> subnetIds;
    private String vpcId;

    private DirectoryVpcSettings() {
    }

    public List<String> availabilityZones() {
        return this.availabilityZones == null ? List.of() : this.availabilityZones;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DirectoryVpcSettings defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private List<String> availabilityZones;
        private List<String> subnetIds;
        private String vpcId;

        public Builder() {
        }

        public Builder(DirectoryVpcSettings defaults) {
            Objects.requireNonNull(defaults);
            this.availabilityZones = defaults.availabilityZones;
            this.subnetIds = defaults.subnetIds;
            this.vpcId = defaults.vpcId;
        }

        @CustomType.Setter
        public Builder availabilityZones(@Nullable List<String> availabilityZones) {
            this.availabilityZones = availabilityZones;
            return this;
        }

        public Builder availabilityZones(String ... availabilityZones) {
            return this.availabilityZones(List.of(availabilityZones));
        }

        @CustomType.Setter
        public Builder subnetIds(List<String> subnetIds) {
            this.subnetIds = Objects.requireNonNull(subnetIds);
            return this;
        }

        public Builder subnetIds(String ... subnetIds) {
            return this.subnetIds(List.of(subnetIds));
        }

        @CustomType.Setter
        public Builder vpcId(String vpcId) {
            this.vpcId = Objects.requireNonNull(vpcId);
            return this;
        }

        public DirectoryVpcSettings build() {
            DirectoryVpcSettings o = new DirectoryVpcSettings();
            o.availabilityZones = this.availabilityZones;
            o.subnetIds = this.subnetIds;
            o.vpcId = this.vpcId;
            return o;
        }
    }
}

