/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.ebs.outputs;

import com.pulumi.aws.ebs.outputs.GetSnapshotFilter;
import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class GetSnapshotResult {
    private String arn;
    private String dataEncryptionKeyId;
    private String description;
    private Boolean encrypted;
    @Nullable
    private List<GetSnapshotFilter> filters;
    private String id;
    private String kmsKeyId;
    @Nullable
    private Boolean mostRecent;
    private String outpostArn;
    private String ownerAlias;
    private String ownerId;
    @Nullable
    private List<String> owners;
    @Nullable
    private List<String> restorableByUserIds;
    private String snapshotId;
    @Nullable
    private List<String> snapshotIds;
    private String state;
    private String storageTier;
    private Map<String, String> tags;
    private String volumeId;
    private Integer volumeSize;

    private GetSnapshotResult() {
    }

    public String arn() {
        return this.arn;
    }

    public String dataEncryptionKeyId() {
        return this.dataEncryptionKeyId;
    }

    public String description() {
        return this.description;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public List<GetSnapshotFilter> filters() {
        return this.filters == null ? List.of() : this.filters;
    }

    public String id() {
        return this.id;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Optional<Boolean> mostRecent() {
        return Optional.ofNullable(this.mostRecent);
    }

    public String outpostArn() {
        return this.outpostArn;
    }

    public String ownerAlias() {
        return this.ownerAlias;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public List<String> owners() {
        return this.owners == null ? List.of() : this.owners;
    }

    public List<String> restorableByUserIds() {
        return this.restorableByUserIds == null ? List.of() : this.restorableByUserIds;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public List<String> snapshotIds() {
        return this.snapshotIds == null ? List.of() : this.snapshotIds;
    }

    public String state() {
        return this.state;
    }

    public String storageTier() {
        return this.storageTier;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public String volumeId() {
        return this.volumeId;
    }

    public Integer volumeSize() {
        return this.volumeSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GetSnapshotResult defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String arn;
        private String dataEncryptionKeyId;
        private String description;
        private Boolean encrypted;
        @Nullable
        private List<GetSnapshotFilter> filters;
        private String id;
        private String kmsKeyId;
        @Nullable
        private Boolean mostRecent;
        private String outpostArn;
        private String ownerAlias;
        private String ownerId;
        @Nullable
        private List<String> owners;
        @Nullable
        private List<String> restorableByUserIds;
        private String snapshotId;
        @Nullable
        private List<String> snapshotIds;
        private String state;
        private String storageTier;
        private Map<String, String> tags;
        private String volumeId;
        private Integer volumeSize;

        public Builder() {
        }

        public Builder(GetSnapshotResult defaults) {
            Objects.requireNonNull(defaults);
            this.arn = defaults.arn;
            this.dataEncryptionKeyId = defaults.dataEncryptionKeyId;
            this.description = defaults.description;
            this.encrypted = defaults.encrypted;
            this.filters = defaults.filters;
            this.id = defaults.id;
            this.kmsKeyId = defaults.kmsKeyId;
            this.mostRecent = defaults.mostRecent;
            this.outpostArn = defaults.outpostArn;
            this.ownerAlias = defaults.ownerAlias;
            this.ownerId = defaults.ownerId;
            this.owners = defaults.owners;
            this.restorableByUserIds = defaults.restorableByUserIds;
            this.snapshotId = defaults.snapshotId;
            this.snapshotIds = defaults.snapshotIds;
            this.state = defaults.state;
            this.storageTier = defaults.storageTier;
            this.tags = defaults.tags;
            this.volumeId = defaults.volumeId;
            this.volumeSize = defaults.volumeSize;
        }

        @CustomType.Setter
        public Builder arn(String arn) {
            this.arn = Objects.requireNonNull(arn);
            return this;
        }

        @CustomType.Setter
        public Builder dataEncryptionKeyId(String dataEncryptionKeyId) {
            this.dataEncryptionKeyId = Objects.requireNonNull(dataEncryptionKeyId);
            return this;
        }

        @CustomType.Setter
        public Builder description(String description) {
            this.description = Objects.requireNonNull(description);
            return this;
        }

        @CustomType.Setter
        public Builder encrypted(Boolean encrypted) {
            this.encrypted = Objects.requireNonNull(encrypted);
            return this;
        }

        @CustomType.Setter
        public Builder filters(@Nullable List<GetSnapshotFilter> filters) {
            this.filters = filters;
            return this;
        }

        public Builder filters(GetSnapshotFilter ... filters) {
            return this.filters(List.of(filters));
        }

        @CustomType.Setter
        public Builder id(String id) {
            this.id = Objects.requireNonNull(id);
            return this;
        }

        @CustomType.Setter
        public Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = Objects.requireNonNull(kmsKeyId);
            return this;
        }

        @CustomType.Setter
        public Builder mostRecent(@Nullable Boolean mostRecent) {
            this.mostRecent = mostRecent;
            return this;
        }

        @CustomType.Setter
        public Builder outpostArn(String outpostArn) {
            this.outpostArn = Objects.requireNonNull(outpostArn);
            return this;
        }

        @CustomType.Setter
        public Builder ownerAlias(String ownerAlias) {
            this.ownerAlias = Objects.requireNonNull(ownerAlias);
            return this;
        }

        @CustomType.Setter
        public Builder ownerId(String ownerId) {
            this.ownerId = Objects.requireNonNull(ownerId);
            return this;
        }

        @CustomType.Setter
        public Builder owners(@Nullable List<String> owners) {
            this.owners = owners;
            return this;
        }

        public Builder owners(String ... owners) {
            return this.owners(List.of(owners));
        }

        @CustomType.Setter
        public Builder restorableByUserIds(@Nullable List<String> restorableByUserIds) {
            this.restorableByUserIds = restorableByUserIds;
            return this;
        }

        public Builder restorableByUserIds(String ... restorableByUserIds) {
            return this.restorableByUserIds(List.of(restorableByUserIds));
        }

        @CustomType.Setter
        public Builder snapshotId(String snapshotId) {
            this.snapshotId = Objects.requireNonNull(snapshotId);
            return this;
        }

        @CustomType.Setter
        public Builder snapshotIds(@Nullable List<String> snapshotIds) {
            this.snapshotIds = snapshotIds;
            return this;
        }

        public Builder snapshotIds(String ... snapshotIds) {
            return this.snapshotIds(List.of(snapshotIds));
        }

        @CustomType.Setter
        public Builder state(String state) {
            this.state = Objects.requireNonNull(state);
            return this;
        }

        @CustomType.Setter
        public Builder storageTier(String storageTier) {
            this.storageTier = Objects.requireNonNull(storageTier);
            return this;
        }

        @CustomType.Setter
        public Builder tags(Map<String, String> tags) {
            this.tags = Objects.requireNonNull(tags);
            return this;
        }

        @CustomType.Setter
        public Builder volumeId(String volumeId) {
            this.volumeId = Objects.requireNonNull(volumeId);
            return this;
        }

        @CustomType.Setter
        public Builder volumeSize(Integer volumeSize) {
            this.volumeSize = Objects.requireNonNull(volumeSize);
            return this;
        }

        public GetSnapshotResult build() {
            GetSnapshotResult o = new GetSnapshotResult();
            o.arn = this.arn;
            o.dataEncryptionKeyId = this.dataEncryptionKeyId;
            o.description = this.description;
            o.encrypted = this.encrypted;
            o.filters = this.filters;
            o.id = this.id;
            o.kmsKeyId = this.kmsKeyId;
            o.mostRecent = this.mostRecent;
            o.outpostArn = this.outpostArn;
            o.ownerAlias = this.ownerAlias;
            o.ownerId = this.ownerId;
            o.owners = this.owners;
            o.restorableByUserIds = this.restorableByUserIds;
            o.snapshotId = this.snapshotId;
            o.snapshotIds = this.snapshotIds;
            o.state = this.state;
            o.storageTier = this.storageTier;
            o.tags = this.tags;
            o.volumeId = this.volumeId;
            o.volumeSize = this.volumeSize;
            return o;
        }
    }
}

