/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.ebs.outputs;

import com.pulumi.aws.ebs.outputs.GetVolumeFilter;
import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class GetVolumeResult {
    private String arn;
    private String availabilityZone;
    private Boolean encrypted;
    @Nullable
    private List<GetVolumeFilter> filters;
    private String id;
    private Integer iops;
    private String kmsKeyId;
    @Nullable
    private Boolean mostRecent;
    private Boolean multiAttachEnabled;
    private String outpostArn;
    private Integer size;
    private String snapshotId;
    private Map<String, String> tags;
    private Integer throughput;
    private String volumeId;
    private String volumeType;

    private GetVolumeResult() {
    }

    public String arn() {
        return this.arn;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public List<GetVolumeFilter> filters() {
        return this.filters == null ? List.of() : this.filters;
    }

    public String id() {
        return this.id;
    }

    public Integer iops() {
        return this.iops;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Optional<Boolean> mostRecent() {
        return Optional.ofNullable(this.mostRecent);
    }

    public Boolean multiAttachEnabled() {
        return this.multiAttachEnabled;
    }

    public String outpostArn() {
        return this.outpostArn;
    }

    public Integer size() {
        return this.size;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Integer throughput() {
        return this.throughput;
    }

    public String volumeId() {
        return this.volumeId;
    }

    public String volumeType() {
        return this.volumeType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GetVolumeResult defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String arn;
        private String availabilityZone;
        private Boolean encrypted;
        @Nullable
        private List<GetVolumeFilter> filters;
        private String id;
        private Integer iops;
        private String kmsKeyId;
        @Nullable
        private Boolean mostRecent;
        private Boolean multiAttachEnabled;
        private String outpostArn;
        private Integer size;
        private String snapshotId;
        private Map<String, String> tags;
        private Integer throughput;
        private String volumeId;
        private String volumeType;

        public Builder() {
        }

        public Builder(GetVolumeResult defaults) {
            Objects.requireNonNull(defaults);
            this.arn = defaults.arn;
            this.availabilityZone = defaults.availabilityZone;
            this.encrypted = defaults.encrypted;
            this.filters = defaults.filters;
            this.id = defaults.id;
            this.iops = defaults.iops;
            this.kmsKeyId = defaults.kmsKeyId;
            this.mostRecent = defaults.mostRecent;
            this.multiAttachEnabled = defaults.multiAttachEnabled;
            this.outpostArn = defaults.outpostArn;
            this.size = defaults.size;
            this.snapshotId = defaults.snapshotId;
            this.tags = defaults.tags;
            this.throughput = defaults.throughput;
            this.volumeId = defaults.volumeId;
            this.volumeType = defaults.volumeType;
        }

        @CustomType.Setter
        public Builder arn(String arn) {
            this.arn = Objects.requireNonNull(arn);
            return this;
        }

        @CustomType.Setter
        public Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = Objects.requireNonNull(availabilityZone);
            return this;
        }

        @CustomType.Setter
        public Builder encrypted(Boolean encrypted) {
            this.encrypted = Objects.requireNonNull(encrypted);
            return this;
        }

        @CustomType.Setter
        public Builder filters(@Nullable List<GetVolumeFilter> filters) {
            this.filters = filters;
            return this;
        }

        public Builder filters(GetVolumeFilter ... filters) {
            return this.filters(List.of(filters));
        }

        @CustomType.Setter
        public Builder id(String id) {
            this.id = Objects.requireNonNull(id);
            return this;
        }

        @CustomType.Setter
        public Builder iops(Integer iops) {
            this.iops = Objects.requireNonNull(iops);
            return this;
        }

        @CustomType.Setter
        public Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = Objects.requireNonNull(kmsKeyId);
            return this;
        }

        @CustomType.Setter
        public Builder mostRecent(@Nullable Boolean mostRecent) {
            this.mostRecent = mostRecent;
            return this;
        }

        @CustomType.Setter
        public Builder multiAttachEnabled(Boolean multiAttachEnabled) {
            this.multiAttachEnabled = Objects.requireNonNull(multiAttachEnabled);
            return this;
        }

        @CustomType.Setter
        public Builder outpostArn(String outpostArn) {
            this.outpostArn = Objects.requireNonNull(outpostArn);
            return this;
        }

        @CustomType.Setter
        public Builder size(Integer size) {
            this.size = Objects.requireNonNull(size);
            return this;
        }

        @CustomType.Setter
        public Builder snapshotId(String snapshotId) {
            this.snapshotId = Objects.requireNonNull(snapshotId);
            return this;
        }

        @CustomType.Setter
        public Builder tags(Map<String, String> tags) {
            this.tags = Objects.requireNonNull(tags);
            return this;
        }

        @CustomType.Setter
        public Builder throughput(Integer throughput) {
            this.throughput = Objects.requireNonNull(throughput);
            return this;
        }

        @CustomType.Setter
        public Builder volumeId(String volumeId) {
            this.volumeId = Objects.requireNonNull(volumeId);
            return this;
        }

        @CustomType.Setter
        public Builder volumeType(String volumeType) {
            this.volumeType = Objects.requireNonNull(volumeType);
            return this;
        }

        public GetVolumeResult build() {
            GetVolumeResult o = new GetVolumeResult();
            o.arn = this.arn;
            o.availabilityZone = this.availabilityZone;
            o.encrypted = this.encrypted;
            o.filters = this.filters;
            o.id = this.id;
            o.iops = this.iops;
            o.kmsKeyId = this.kmsKeyId;
            o.mostRecent = this.mostRecent;
            o.multiAttachEnabled = this.multiAttachEnabled;
            o.outpostArn = this.outpostArn;
            o.size = this.size;
            o.snapshotId = this.snapshotId;
            o.tags = this.tags;
            o.throughput = this.throughput;
            o.volumeId = this.volumeId;
            o.volumeType = this.volumeType;
            return o;
        }
    }
}

