/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.ec2;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.resources.ResourceArgs;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class VpcIpamPoolArgs
extends ResourceArgs {
    public static final VpcIpamPoolArgs Empty = new VpcIpamPoolArgs();
    @Import(name="addressFamily", required=true)
    private Output<String> addressFamily;
    @Import(name="allocationDefaultNetmaskLength")
    @Nullable
    private Output<Integer> allocationDefaultNetmaskLength;
    @Import(name="allocationMaxNetmaskLength")
    @Nullable
    private Output<Integer> allocationMaxNetmaskLength;
    @Import(name="allocationMinNetmaskLength")
    @Nullable
    private Output<Integer> allocationMinNetmaskLength;
    @Import(name="allocationResourceTags")
    @Nullable
    private Output<Map<String, String>> allocationResourceTags;
    @Import(name="autoImport")
    @Nullable
    private Output<Boolean> autoImport;
    @Import(name="awsService")
    @Nullable
    private Output<String> awsService;
    @Import(name="description")
    @Nullable
    private Output<String> description;
    @Import(name="ipamScopeId", required=true)
    private Output<String> ipamScopeId;
    @Import(name="locale")
    @Nullable
    private Output<String> locale;
    @Import(name="publicIpSource")
    @Nullable
    private Output<String> publicIpSource;
    @Import(name="publiclyAdvertisable")
    @Nullable
    private Output<Boolean> publiclyAdvertisable;
    @Import(name="sourceIpamPoolId")
    @Nullable
    private Output<String> sourceIpamPoolId;
    @Import(name="tags")
    @Nullable
    private Output<Map<String, String>> tags;

    public Output<String> addressFamily() {
        return this.addressFamily;
    }

    public Optional<Output<Integer>> allocationDefaultNetmaskLength() {
        return Optional.ofNullable(this.allocationDefaultNetmaskLength);
    }

    public Optional<Output<Integer>> allocationMaxNetmaskLength() {
        return Optional.ofNullable(this.allocationMaxNetmaskLength);
    }

    public Optional<Output<Integer>> allocationMinNetmaskLength() {
        return Optional.ofNullable(this.allocationMinNetmaskLength);
    }

    public Optional<Output<Map<String, String>>> allocationResourceTags() {
        return Optional.ofNullable(this.allocationResourceTags);
    }

    public Optional<Output<Boolean>> autoImport() {
        return Optional.ofNullable(this.autoImport);
    }

    public Optional<Output<String>> awsService() {
        return Optional.ofNullable(this.awsService);
    }

    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    public Output<String> ipamScopeId() {
        return this.ipamScopeId;
    }

    public Optional<Output<String>> locale() {
        return Optional.ofNullable(this.locale);
    }

    public Optional<Output<String>> publicIpSource() {
        return Optional.ofNullable(this.publicIpSource);
    }

    public Optional<Output<Boolean>> publiclyAdvertisable() {
        return Optional.ofNullable(this.publiclyAdvertisable);
    }

    public Optional<Output<String>> sourceIpamPoolId() {
        return Optional.ofNullable(this.sourceIpamPoolId);
    }

    public Optional<Output<Map<String, String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    private VpcIpamPoolArgs() {
    }

    private VpcIpamPoolArgs(VpcIpamPoolArgs $) {
        this.addressFamily = $.addressFamily;
        this.allocationDefaultNetmaskLength = $.allocationDefaultNetmaskLength;
        this.allocationMaxNetmaskLength = $.allocationMaxNetmaskLength;
        this.allocationMinNetmaskLength = $.allocationMinNetmaskLength;
        this.allocationResourceTags = $.allocationResourceTags;
        this.autoImport = $.autoImport;
        this.awsService = $.awsService;
        this.description = $.description;
        this.ipamScopeId = $.ipamScopeId;
        this.locale = $.locale;
        this.publicIpSource = $.publicIpSource;
        this.publiclyAdvertisable = $.publiclyAdvertisable;
        this.sourceIpamPoolId = $.sourceIpamPoolId;
        this.tags = $.tags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(VpcIpamPoolArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private VpcIpamPoolArgs $;

        public Builder() {
            this.$ = new VpcIpamPoolArgs();
        }

        public Builder(VpcIpamPoolArgs defaults) {
            this.$ = new VpcIpamPoolArgs(Objects.requireNonNull(defaults));
        }

        public Builder addressFamily(Output<String> addressFamily) {
            this.$.addressFamily = addressFamily;
            return this;
        }

        public Builder addressFamily(String addressFamily) {
            return this.addressFamily((Output<String>)Output.of((Object)addressFamily));
        }

        public Builder allocationDefaultNetmaskLength(@Nullable Output<Integer> allocationDefaultNetmaskLength) {
            this.$.allocationDefaultNetmaskLength = allocationDefaultNetmaskLength;
            return this;
        }

        public Builder allocationDefaultNetmaskLength(Integer allocationDefaultNetmaskLength) {
            return this.allocationDefaultNetmaskLength((Output<Integer>)Output.of((Object)allocationDefaultNetmaskLength));
        }

        public Builder allocationMaxNetmaskLength(@Nullable Output<Integer> allocationMaxNetmaskLength) {
            this.$.allocationMaxNetmaskLength = allocationMaxNetmaskLength;
            return this;
        }

        public Builder allocationMaxNetmaskLength(Integer allocationMaxNetmaskLength) {
            return this.allocationMaxNetmaskLength((Output<Integer>)Output.of((Object)allocationMaxNetmaskLength));
        }

        public Builder allocationMinNetmaskLength(@Nullable Output<Integer> allocationMinNetmaskLength) {
            this.$.allocationMinNetmaskLength = allocationMinNetmaskLength;
            return this;
        }

        public Builder allocationMinNetmaskLength(Integer allocationMinNetmaskLength) {
            return this.allocationMinNetmaskLength((Output<Integer>)Output.of((Object)allocationMinNetmaskLength));
        }

        public Builder allocationResourceTags(@Nullable Output<Map<String, String>> allocationResourceTags) {
            this.$.allocationResourceTags = allocationResourceTags;
            return this;
        }

        public Builder allocationResourceTags(Map<String, String> allocationResourceTags) {
            return this.allocationResourceTags((Output<Map<String, String>>)Output.of(allocationResourceTags));
        }

        public Builder autoImport(@Nullable Output<Boolean> autoImport) {
            this.$.autoImport = autoImport;
            return this;
        }

        public Builder autoImport(Boolean autoImport) {
            return this.autoImport((Output<Boolean>)Output.of((Object)autoImport));
        }

        public Builder awsService(@Nullable Output<String> awsService) {
            this.$.awsService = awsService;
            return this;
        }

        public Builder awsService(String awsService) {
            return this.awsService((Output<String>)Output.of((Object)awsService));
        }

        public Builder description(@Nullable Output<String> description) {
            this.$.description = description;
            return this;
        }

        public Builder description(String description) {
            return this.description((Output<String>)Output.of((Object)description));
        }

        public Builder ipamScopeId(Output<String> ipamScopeId) {
            this.$.ipamScopeId = ipamScopeId;
            return this;
        }

        public Builder ipamScopeId(String ipamScopeId) {
            return this.ipamScopeId((Output<String>)Output.of((Object)ipamScopeId));
        }

        public Builder locale(@Nullable Output<String> locale) {
            this.$.locale = locale;
            return this;
        }

        public Builder locale(String locale) {
            return this.locale((Output<String>)Output.of((Object)locale));
        }

        public Builder publicIpSource(@Nullable Output<String> publicIpSource) {
            this.$.publicIpSource = publicIpSource;
            return this;
        }

        public Builder publicIpSource(String publicIpSource) {
            return this.publicIpSource((Output<String>)Output.of((Object)publicIpSource));
        }

        public Builder publiclyAdvertisable(@Nullable Output<Boolean> publiclyAdvertisable) {
            this.$.publiclyAdvertisable = publiclyAdvertisable;
            return this;
        }

        public Builder publiclyAdvertisable(Boolean publiclyAdvertisable) {
            return this.publiclyAdvertisable((Output<Boolean>)Output.of((Object)publiclyAdvertisable));
        }

        public Builder sourceIpamPoolId(@Nullable Output<String> sourceIpamPoolId) {
            this.$.sourceIpamPoolId = sourceIpamPoolId;
            return this;
        }

        public Builder sourceIpamPoolId(String sourceIpamPoolId) {
            return this.sourceIpamPoolId((Output<String>)Output.of((Object)sourceIpamPoolId));
        }

        public Builder tags(@Nullable Output<Map<String, String>> tags) {
            this.$.tags = tags;
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            return this.tags((Output<Map<String, String>>)Output.of(tags));
        }

        public VpcIpamPoolArgs build() {
            this.$.addressFamily = Objects.requireNonNull(this.$.addressFamily, "expected parameter 'addressFamily' to be non-null");
            this.$.ipamScopeId = Objects.requireNonNull(this.$.ipamScopeId, "expected parameter 'ipamScopeId' to be non-null");
            return this.$;
        }
    }
}

