/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.ec2.outputs;

import com.pulumi.aws.ec2.outputs.GetInstanceCreditSpecification;
import com.pulumi.aws.ec2.outputs.GetInstanceEbsBlockDevice;
import com.pulumi.aws.ec2.outputs.GetInstanceEnclaveOption;
import com.pulumi.aws.ec2.outputs.GetInstanceEphemeralBlockDevice;
import com.pulumi.aws.ec2.outputs.GetInstanceFilter;
import com.pulumi.aws.ec2.outputs.GetInstanceMaintenanceOption;
import com.pulumi.aws.ec2.outputs.GetInstanceMetadataOption;
import com.pulumi.aws.ec2.outputs.GetInstancePrivateDnsNameOption;
import com.pulumi.aws.ec2.outputs.GetInstanceRootBlockDevice;
import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class GetInstanceResult {
    private String ami;
    private String arn;
    private Boolean associatePublicIpAddress;
    private String availabilityZone;
    private List<GetInstanceCreditSpecification> creditSpecifications;
    private Boolean disableApiStop;
    private Boolean disableApiTermination;
    private List<GetInstanceEbsBlockDevice> ebsBlockDevices;
    private Boolean ebsOptimized;
    private List<GetInstanceEnclaveOption> enclaveOptions;
    private List<GetInstanceEphemeralBlockDevice> ephemeralBlockDevices;
    @Nullable
    private List<GetInstanceFilter> filters;
    @Nullable
    private Boolean getPasswordData;
    @Nullable
    private Boolean getUserData;
    private String hostId;
    private String hostResourceGroupArn;
    private String iamInstanceProfile;
    private String id;
    @Nullable
    private String instanceId;
    private String instanceState;
    private Map<String, String> instanceTags;
    private String instanceType;
    private List<String> ipv6Addresses;
    private String keyName;
    private List<GetInstanceMaintenanceOption> maintenanceOptions;
    private List<GetInstanceMetadataOption> metadataOptions;
    private Boolean monitoring;
    private String networkInterfaceId;
    private String outpostArn;
    private String passwordData;
    private String placementGroup;
    private Integer placementPartitionNumber;
    private String privateDns;
    private List<GetInstancePrivateDnsNameOption> privateDnsNameOptions;
    private String privateIp;
    private String publicDns;
    private String publicIp;
    private List<GetInstanceRootBlockDevice> rootBlockDevices;
    private List<String> secondaryPrivateIps;
    private List<String> securityGroups;
    private Boolean sourceDestCheck;
    private String subnetId;
    private Map<String, String> tags;
    private String tenancy;
    private String userData;
    private String userDataBase64;
    private List<String> vpcSecurityGroupIds;

    private GetInstanceResult() {
    }

    public String ami() {
        return this.ami;
    }

    public String arn() {
        return this.arn;
    }

    public Boolean associatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public List<GetInstanceCreditSpecification> creditSpecifications() {
        return this.creditSpecifications;
    }

    public Boolean disableApiStop() {
        return this.disableApiStop;
    }

    public Boolean disableApiTermination() {
        return this.disableApiTermination;
    }

    public List<GetInstanceEbsBlockDevice> ebsBlockDevices() {
        return this.ebsBlockDevices;
    }

    public Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public List<GetInstanceEnclaveOption> enclaveOptions() {
        return this.enclaveOptions;
    }

    public List<GetInstanceEphemeralBlockDevice> ephemeralBlockDevices() {
        return this.ephemeralBlockDevices;
    }

    public List<GetInstanceFilter> filters() {
        return this.filters == null ? List.of() : this.filters;
    }

    public Optional<Boolean> getPasswordData() {
        return Optional.ofNullable(this.getPasswordData);
    }

    public Optional<Boolean> getUserData() {
        return Optional.ofNullable(this.getUserData);
    }

    public String hostId() {
        return this.hostId;
    }

    public String hostResourceGroupArn() {
        return this.hostResourceGroupArn;
    }

    public String iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public String id() {
        return this.id;
    }

    public Optional<String> instanceId() {
        return Optional.ofNullable(this.instanceId);
    }

    public String instanceState() {
        return this.instanceState;
    }

    public Map<String, String> instanceTags() {
        return this.instanceTags;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public List<String> ipv6Addresses() {
        return this.ipv6Addresses;
    }

    public String keyName() {
        return this.keyName;
    }

    public List<GetInstanceMaintenanceOption> maintenanceOptions() {
        return this.maintenanceOptions;
    }

    public List<GetInstanceMetadataOption> metadataOptions() {
        return this.metadataOptions;
    }

    public Boolean monitoring() {
        return this.monitoring;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public String outpostArn() {
        return this.outpostArn;
    }

    public String passwordData() {
        return this.passwordData;
    }

    public String placementGroup() {
        return this.placementGroup;
    }

    public Integer placementPartitionNumber() {
        return this.placementPartitionNumber;
    }

    public String privateDns() {
        return this.privateDns;
    }

    public List<GetInstancePrivateDnsNameOption> privateDnsNameOptions() {
        return this.privateDnsNameOptions;
    }

    public String privateIp() {
        return this.privateIp;
    }

    public String publicDns() {
        return this.publicDns;
    }

    public String publicIp() {
        return this.publicIp;
    }

    public List<GetInstanceRootBlockDevice> rootBlockDevices() {
        return this.rootBlockDevices;
    }

    public List<String> secondaryPrivateIps() {
        return this.secondaryPrivateIps;
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public Boolean sourceDestCheck() {
        return this.sourceDestCheck;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public String tenancy() {
        return this.tenancy;
    }

    public String userData() {
        return this.userData;
    }

    public String userDataBase64() {
        return this.userDataBase64;
    }

    public List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GetInstanceResult defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String ami;
        private String arn;
        private Boolean associatePublicIpAddress;
        private String availabilityZone;
        private List<GetInstanceCreditSpecification> creditSpecifications;
        private Boolean disableApiStop;
        private Boolean disableApiTermination;
        private List<GetInstanceEbsBlockDevice> ebsBlockDevices;
        private Boolean ebsOptimized;
        private List<GetInstanceEnclaveOption> enclaveOptions;
        private List<GetInstanceEphemeralBlockDevice> ephemeralBlockDevices;
        @Nullable
        private List<GetInstanceFilter> filters;
        @Nullable
        private Boolean getPasswordData;
        @Nullable
        private Boolean getUserData;
        private String hostId;
        private String hostResourceGroupArn;
        private String iamInstanceProfile;
        private String id;
        @Nullable
        private String instanceId;
        private String instanceState;
        private Map<String, String> instanceTags;
        private String instanceType;
        private List<String> ipv6Addresses;
        private String keyName;
        private List<GetInstanceMaintenanceOption> maintenanceOptions;
        private List<GetInstanceMetadataOption> metadataOptions;
        private Boolean monitoring;
        private String networkInterfaceId;
        private String outpostArn;
        private String passwordData;
        private String placementGroup;
        private Integer placementPartitionNumber;
        private String privateDns;
        private List<GetInstancePrivateDnsNameOption> privateDnsNameOptions;
        private String privateIp;
        private String publicDns;
        private String publicIp;
        private List<GetInstanceRootBlockDevice> rootBlockDevices;
        private List<String> secondaryPrivateIps;
        private List<String> securityGroups;
        private Boolean sourceDestCheck;
        private String subnetId;
        private Map<String, String> tags;
        private String tenancy;
        private String userData;
        private String userDataBase64;
        private List<String> vpcSecurityGroupIds;

        public Builder() {
        }

        public Builder(GetInstanceResult defaults) {
            Objects.requireNonNull(defaults);
            this.ami = defaults.ami;
            this.arn = defaults.arn;
            this.associatePublicIpAddress = defaults.associatePublicIpAddress;
            this.availabilityZone = defaults.availabilityZone;
            this.creditSpecifications = defaults.creditSpecifications;
            this.disableApiStop = defaults.disableApiStop;
            this.disableApiTermination = defaults.disableApiTermination;
            this.ebsBlockDevices = defaults.ebsBlockDevices;
            this.ebsOptimized = defaults.ebsOptimized;
            this.enclaveOptions = defaults.enclaveOptions;
            this.ephemeralBlockDevices = defaults.ephemeralBlockDevices;
            this.filters = defaults.filters;
            this.getPasswordData = defaults.getPasswordData;
            this.getUserData = defaults.getUserData;
            this.hostId = defaults.hostId;
            this.hostResourceGroupArn = defaults.hostResourceGroupArn;
            this.iamInstanceProfile = defaults.iamInstanceProfile;
            this.id = defaults.id;
            this.instanceId = defaults.instanceId;
            this.instanceState = defaults.instanceState;
            this.instanceTags = defaults.instanceTags;
            this.instanceType = defaults.instanceType;
            this.ipv6Addresses = defaults.ipv6Addresses;
            this.keyName = defaults.keyName;
            this.maintenanceOptions = defaults.maintenanceOptions;
            this.metadataOptions = defaults.metadataOptions;
            this.monitoring = defaults.monitoring;
            this.networkInterfaceId = defaults.networkInterfaceId;
            this.outpostArn = defaults.outpostArn;
            this.passwordData = defaults.passwordData;
            this.placementGroup = defaults.placementGroup;
            this.placementPartitionNumber = defaults.placementPartitionNumber;
            this.privateDns = defaults.privateDns;
            this.privateDnsNameOptions = defaults.privateDnsNameOptions;
            this.privateIp = defaults.privateIp;
            this.publicDns = defaults.publicDns;
            this.publicIp = defaults.publicIp;
            this.rootBlockDevices = defaults.rootBlockDevices;
            this.secondaryPrivateIps = defaults.secondaryPrivateIps;
            this.securityGroups = defaults.securityGroups;
            this.sourceDestCheck = defaults.sourceDestCheck;
            this.subnetId = defaults.subnetId;
            this.tags = defaults.tags;
            this.tenancy = defaults.tenancy;
            this.userData = defaults.userData;
            this.userDataBase64 = defaults.userDataBase64;
            this.vpcSecurityGroupIds = defaults.vpcSecurityGroupIds;
        }

        @CustomType.Setter
        public Builder ami(String ami) {
            this.ami = Objects.requireNonNull(ami);
            return this;
        }

        @CustomType.Setter
        public Builder arn(String arn) {
            this.arn = Objects.requireNonNull(arn);
            return this;
        }

        @CustomType.Setter
        public Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = Objects.requireNonNull(associatePublicIpAddress);
            return this;
        }

        @CustomType.Setter
        public Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = Objects.requireNonNull(availabilityZone);
            return this;
        }

        @CustomType.Setter
        public Builder creditSpecifications(List<GetInstanceCreditSpecification> creditSpecifications) {
            this.creditSpecifications = Objects.requireNonNull(creditSpecifications);
            return this;
        }

        public Builder creditSpecifications(GetInstanceCreditSpecification ... creditSpecifications) {
            return this.creditSpecifications(List.of(creditSpecifications));
        }

        @CustomType.Setter
        public Builder disableApiStop(Boolean disableApiStop) {
            this.disableApiStop = Objects.requireNonNull(disableApiStop);
            return this;
        }

        @CustomType.Setter
        public Builder disableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = Objects.requireNonNull(disableApiTermination);
            return this;
        }

        @CustomType.Setter
        public Builder ebsBlockDevices(List<GetInstanceEbsBlockDevice> ebsBlockDevices) {
            this.ebsBlockDevices = Objects.requireNonNull(ebsBlockDevices);
            return this;
        }

        public Builder ebsBlockDevices(GetInstanceEbsBlockDevice ... ebsBlockDevices) {
            return this.ebsBlockDevices(List.of(ebsBlockDevices));
        }

        @CustomType.Setter
        public Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = Objects.requireNonNull(ebsOptimized);
            return this;
        }

        @CustomType.Setter
        public Builder enclaveOptions(List<GetInstanceEnclaveOption> enclaveOptions) {
            this.enclaveOptions = Objects.requireNonNull(enclaveOptions);
            return this;
        }

        public Builder enclaveOptions(GetInstanceEnclaveOption ... enclaveOptions) {
            return this.enclaveOptions(List.of(enclaveOptions));
        }

        @CustomType.Setter
        public Builder ephemeralBlockDevices(List<GetInstanceEphemeralBlockDevice> ephemeralBlockDevices) {
            this.ephemeralBlockDevices = Objects.requireNonNull(ephemeralBlockDevices);
            return this;
        }

        public Builder ephemeralBlockDevices(GetInstanceEphemeralBlockDevice ... ephemeralBlockDevices) {
            return this.ephemeralBlockDevices(List.of(ephemeralBlockDevices));
        }

        @CustomType.Setter
        public Builder filters(@Nullable List<GetInstanceFilter> filters) {
            this.filters = filters;
            return this;
        }

        public Builder filters(GetInstanceFilter ... filters) {
            return this.filters(List.of(filters));
        }

        @CustomType.Setter
        public Builder getPasswordData(@Nullable Boolean getPasswordData) {
            this.getPasswordData = getPasswordData;
            return this;
        }

        @CustomType.Setter
        public Builder getUserData(@Nullable Boolean getUserData) {
            this.getUserData = getUserData;
            return this;
        }

        @CustomType.Setter
        public Builder hostId(String hostId) {
            this.hostId = Objects.requireNonNull(hostId);
            return this;
        }

        @CustomType.Setter
        public Builder hostResourceGroupArn(String hostResourceGroupArn) {
            this.hostResourceGroupArn = Objects.requireNonNull(hostResourceGroupArn);
            return this;
        }

        @CustomType.Setter
        public Builder iamInstanceProfile(String iamInstanceProfile) {
            this.iamInstanceProfile = Objects.requireNonNull(iamInstanceProfile);
            return this;
        }

        @CustomType.Setter
        public Builder id(String id) {
            this.id = Objects.requireNonNull(id);
            return this;
        }

        @CustomType.Setter
        public Builder instanceId(@Nullable String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        @CustomType.Setter
        public Builder instanceState(String instanceState) {
            this.instanceState = Objects.requireNonNull(instanceState);
            return this;
        }

        @CustomType.Setter
        public Builder instanceTags(Map<String, String> instanceTags) {
            this.instanceTags = Objects.requireNonNull(instanceTags);
            return this;
        }

        @CustomType.Setter
        public Builder instanceType(String instanceType) {
            this.instanceType = Objects.requireNonNull(instanceType);
            return this;
        }

        @CustomType.Setter
        public Builder ipv6Addresses(List<String> ipv6Addresses) {
            this.ipv6Addresses = Objects.requireNonNull(ipv6Addresses);
            return this;
        }

        public Builder ipv6Addresses(String ... ipv6Addresses) {
            return this.ipv6Addresses(List.of(ipv6Addresses));
        }

        @CustomType.Setter
        public Builder keyName(String keyName) {
            this.keyName = Objects.requireNonNull(keyName);
            return this;
        }

        @CustomType.Setter
        public Builder maintenanceOptions(List<GetInstanceMaintenanceOption> maintenanceOptions) {
            this.maintenanceOptions = Objects.requireNonNull(maintenanceOptions);
            return this;
        }

        public Builder maintenanceOptions(GetInstanceMaintenanceOption ... maintenanceOptions) {
            return this.maintenanceOptions(List.of(maintenanceOptions));
        }

        @CustomType.Setter
        public Builder metadataOptions(List<GetInstanceMetadataOption> metadataOptions) {
            this.metadataOptions = Objects.requireNonNull(metadataOptions);
            return this;
        }

        public Builder metadataOptions(GetInstanceMetadataOption ... metadataOptions) {
            return this.metadataOptions(List.of(metadataOptions));
        }

        @CustomType.Setter
        public Builder monitoring(Boolean monitoring) {
            this.monitoring = Objects.requireNonNull(monitoring);
            return this;
        }

        @CustomType.Setter
        public Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = Objects.requireNonNull(networkInterfaceId);
            return this;
        }

        @CustomType.Setter
        public Builder outpostArn(String outpostArn) {
            this.outpostArn = Objects.requireNonNull(outpostArn);
            return this;
        }

        @CustomType.Setter
        public Builder passwordData(String passwordData) {
            this.passwordData = Objects.requireNonNull(passwordData);
            return this;
        }

        @CustomType.Setter
        public Builder placementGroup(String placementGroup) {
            this.placementGroup = Objects.requireNonNull(placementGroup);
            return this;
        }

        @CustomType.Setter
        public Builder placementPartitionNumber(Integer placementPartitionNumber) {
            this.placementPartitionNumber = Objects.requireNonNull(placementPartitionNumber);
            return this;
        }

        @CustomType.Setter
        public Builder privateDns(String privateDns) {
            this.privateDns = Objects.requireNonNull(privateDns);
            return this;
        }

        @CustomType.Setter
        public Builder privateDnsNameOptions(List<GetInstancePrivateDnsNameOption> privateDnsNameOptions) {
            this.privateDnsNameOptions = Objects.requireNonNull(privateDnsNameOptions);
            return this;
        }

        public Builder privateDnsNameOptions(GetInstancePrivateDnsNameOption ... privateDnsNameOptions) {
            return this.privateDnsNameOptions(List.of(privateDnsNameOptions));
        }

        @CustomType.Setter
        public Builder privateIp(String privateIp) {
            this.privateIp = Objects.requireNonNull(privateIp);
            return this;
        }

        @CustomType.Setter
        public Builder publicDns(String publicDns) {
            this.publicDns = Objects.requireNonNull(publicDns);
            return this;
        }

        @CustomType.Setter
        public Builder publicIp(String publicIp) {
            this.publicIp = Objects.requireNonNull(publicIp);
            return this;
        }

        @CustomType.Setter
        public Builder rootBlockDevices(List<GetInstanceRootBlockDevice> rootBlockDevices) {
            this.rootBlockDevices = Objects.requireNonNull(rootBlockDevices);
            return this;
        }

        public Builder rootBlockDevices(GetInstanceRootBlockDevice ... rootBlockDevices) {
            return this.rootBlockDevices(List.of(rootBlockDevices));
        }

        @CustomType.Setter
        public Builder secondaryPrivateIps(List<String> secondaryPrivateIps) {
            this.secondaryPrivateIps = Objects.requireNonNull(secondaryPrivateIps);
            return this;
        }

        public Builder secondaryPrivateIps(String ... secondaryPrivateIps) {
            return this.secondaryPrivateIps(List.of(secondaryPrivateIps));
        }

        @CustomType.Setter
        public Builder securityGroups(List<String> securityGroups) {
            this.securityGroups = Objects.requireNonNull(securityGroups);
            return this;
        }

        public Builder securityGroups(String ... securityGroups) {
            return this.securityGroups(List.of(securityGroups));
        }

        @CustomType.Setter
        public Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = Objects.requireNonNull(sourceDestCheck);
            return this;
        }

        @CustomType.Setter
        public Builder subnetId(String subnetId) {
            this.subnetId = Objects.requireNonNull(subnetId);
            return this;
        }

        @CustomType.Setter
        public Builder tags(Map<String, String> tags) {
            this.tags = Objects.requireNonNull(tags);
            return this;
        }

        @CustomType.Setter
        public Builder tenancy(String tenancy) {
            this.tenancy = Objects.requireNonNull(tenancy);
            return this;
        }

        @CustomType.Setter
        public Builder userData(String userData) {
            this.userData = Objects.requireNonNull(userData);
            return this;
        }

        @CustomType.Setter
        public Builder userDataBase64(String userDataBase64) {
            this.userDataBase64 = Objects.requireNonNull(userDataBase64);
            return this;
        }

        @CustomType.Setter
        public Builder vpcSecurityGroupIds(List<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = Objects.requireNonNull(vpcSecurityGroupIds);
            return this;
        }

        public Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            return this.vpcSecurityGroupIds(List.of(vpcSecurityGroupIds));
        }

        public GetInstanceResult build() {
            GetInstanceResult o = new GetInstanceResult();
            o.ami = this.ami;
            o.arn = this.arn;
            o.associatePublicIpAddress = this.associatePublicIpAddress;
            o.availabilityZone = this.availabilityZone;
            o.creditSpecifications = this.creditSpecifications;
            o.disableApiStop = this.disableApiStop;
            o.disableApiTermination = this.disableApiTermination;
            o.ebsBlockDevices = this.ebsBlockDevices;
            o.ebsOptimized = this.ebsOptimized;
            o.enclaveOptions = this.enclaveOptions;
            o.ephemeralBlockDevices = this.ephemeralBlockDevices;
            o.filters = this.filters;
            o.getPasswordData = this.getPasswordData;
            o.getUserData = this.getUserData;
            o.hostId = this.hostId;
            o.hostResourceGroupArn = this.hostResourceGroupArn;
            o.iamInstanceProfile = this.iamInstanceProfile;
            o.id = this.id;
            o.instanceId = this.instanceId;
            o.instanceState = this.instanceState;
            o.instanceTags = this.instanceTags;
            o.instanceType = this.instanceType;
            o.ipv6Addresses = this.ipv6Addresses;
            o.keyName = this.keyName;
            o.maintenanceOptions = this.maintenanceOptions;
            o.metadataOptions = this.metadataOptions;
            o.monitoring = this.monitoring;
            o.networkInterfaceId = this.networkInterfaceId;
            o.outpostArn = this.outpostArn;
            o.passwordData = this.passwordData;
            o.placementGroup = this.placementGroup;
            o.placementPartitionNumber = this.placementPartitionNumber;
            o.privateDns = this.privateDns;
            o.privateDnsNameOptions = this.privateDnsNameOptions;
            o.privateIp = this.privateIp;
            o.publicDns = this.publicDns;
            o.publicIp = this.publicIp;
            o.rootBlockDevices = this.rootBlockDevices;
            o.secondaryPrivateIps = this.secondaryPrivateIps;
            o.securityGroups = this.securityGroups;
            o.sourceDestCheck = this.sourceDestCheck;
            o.subnetId = this.subnetId;
            o.tags = this.tags;
            o.tenancy = this.tenancy;
            o.userData = this.userData;
            o.userDataBase64 = this.userDataBase64;
            o.vpcSecurityGroupIds = this.vpcSecurityGroupIds;
            return o;
        }
    }
}

