/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.ec2.outputs;

import com.pulumi.aws.ec2.outputs.GetInstanceTypeOfferingFilter;
import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class GetInstanceTypeOfferingResult {
    @Nullable
    private List<GetInstanceTypeOfferingFilter> filters;
    private String id;
    private String instanceType;
    @Nullable
    private String locationType;
    @Nullable
    private List<String> preferredInstanceTypes;

    private GetInstanceTypeOfferingResult() {
    }

    public List<GetInstanceTypeOfferingFilter> filters() {
        return this.filters == null ? List.of() : this.filters;
    }

    public String id() {
        return this.id;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public Optional<String> locationType() {
        return Optional.ofNullable(this.locationType);
    }

    public List<String> preferredInstanceTypes() {
        return this.preferredInstanceTypes == null ? List.of() : this.preferredInstanceTypes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GetInstanceTypeOfferingResult defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private List<GetInstanceTypeOfferingFilter> filters;
        private String id;
        private String instanceType;
        @Nullable
        private String locationType;
        @Nullable
        private List<String> preferredInstanceTypes;

        public Builder() {
        }

        public Builder(GetInstanceTypeOfferingResult defaults) {
            Objects.requireNonNull(defaults);
            this.filters = defaults.filters;
            this.id = defaults.id;
            this.instanceType = defaults.instanceType;
            this.locationType = defaults.locationType;
            this.preferredInstanceTypes = defaults.preferredInstanceTypes;
        }

        @CustomType.Setter
        public Builder filters(@Nullable List<GetInstanceTypeOfferingFilter> filters) {
            this.filters = filters;
            return this;
        }

        public Builder filters(GetInstanceTypeOfferingFilter ... filters) {
            return this.filters(List.of(filters));
        }

        @CustomType.Setter
        public Builder id(String id) {
            this.id = Objects.requireNonNull(id);
            return this;
        }

        @CustomType.Setter
        public Builder instanceType(String instanceType) {
            this.instanceType = Objects.requireNonNull(instanceType);
            return this;
        }

        @CustomType.Setter
        public Builder locationType(@Nullable String locationType) {
            this.locationType = locationType;
            return this;
        }

        @CustomType.Setter
        public Builder preferredInstanceTypes(@Nullable List<String> preferredInstanceTypes) {
            this.preferredInstanceTypes = preferredInstanceTypes;
            return this;
        }

        public Builder preferredInstanceTypes(String ... preferredInstanceTypes) {
            return this.preferredInstanceTypes(List.of(preferredInstanceTypes));
        }

        public GetInstanceTypeOfferingResult build() {
            GetInstanceTypeOfferingResult o = new GetInstanceTypeOfferingResult();
            o.filters = this.filters;
            o.id = this.id;
            o.instanceType = this.instanceType;
            o.locationType = this.locationType;
            o.preferredInstanceTypes = this.preferredInstanceTypes;
            return o;
        }
    }
}

