/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.ec2.outputs;

import com.pulumi.aws.ec2.outputs.GetKeyPairFilter;
import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class GetKeyPairResult {
    private String arn;
    private String createTime;
    @Nullable
    private List<GetKeyPairFilter> filters;
    private String fingerprint;
    private String id;
    @Nullable
    private Boolean includePublicKey;
    @Nullable
    private String keyName;
    @Nullable
    private String keyPairId;
    private String keyType;
    private String publicKey;
    private Map<String, String> tags;

    private GetKeyPairResult() {
    }

    public String arn() {
        return this.arn;
    }

    public String createTime() {
        return this.createTime;
    }

    public List<GetKeyPairFilter> filters() {
        return this.filters == null ? List.of() : this.filters;
    }

    public String fingerprint() {
        return this.fingerprint;
    }

    public String id() {
        return this.id;
    }

    public Optional<Boolean> includePublicKey() {
        return Optional.ofNullable(this.includePublicKey);
    }

    public Optional<String> keyName() {
        return Optional.ofNullable(this.keyName);
    }

    public Optional<String> keyPairId() {
        return Optional.ofNullable(this.keyPairId);
    }

    public String keyType() {
        return this.keyType;
    }

    public String publicKey() {
        return this.publicKey;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GetKeyPairResult defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String arn;
        private String createTime;
        @Nullable
        private List<GetKeyPairFilter> filters;
        private String fingerprint;
        private String id;
        @Nullable
        private Boolean includePublicKey;
        @Nullable
        private String keyName;
        @Nullable
        private String keyPairId;
        private String keyType;
        private String publicKey;
        private Map<String, String> tags;

        public Builder() {
        }

        public Builder(GetKeyPairResult defaults) {
            Objects.requireNonNull(defaults);
            this.arn = defaults.arn;
            this.createTime = defaults.createTime;
            this.filters = defaults.filters;
            this.fingerprint = defaults.fingerprint;
            this.id = defaults.id;
            this.includePublicKey = defaults.includePublicKey;
            this.keyName = defaults.keyName;
            this.keyPairId = defaults.keyPairId;
            this.keyType = defaults.keyType;
            this.publicKey = defaults.publicKey;
            this.tags = defaults.tags;
        }

        @CustomType.Setter
        public Builder arn(String arn) {
            this.arn = Objects.requireNonNull(arn);
            return this;
        }

        @CustomType.Setter
        public Builder createTime(String createTime) {
            this.createTime = Objects.requireNonNull(createTime);
            return this;
        }

        @CustomType.Setter
        public Builder filters(@Nullable List<GetKeyPairFilter> filters) {
            this.filters = filters;
            return this;
        }

        public Builder filters(GetKeyPairFilter ... filters) {
            return this.filters(List.of(filters));
        }

        @CustomType.Setter
        public Builder fingerprint(String fingerprint) {
            this.fingerprint = Objects.requireNonNull(fingerprint);
            return this;
        }

        @CustomType.Setter
        public Builder id(String id) {
            this.id = Objects.requireNonNull(id);
            return this;
        }

        @CustomType.Setter
        public Builder includePublicKey(@Nullable Boolean includePublicKey) {
            this.includePublicKey = includePublicKey;
            return this;
        }

        @CustomType.Setter
        public Builder keyName(@Nullable String keyName) {
            this.keyName = keyName;
            return this;
        }

        @CustomType.Setter
        public Builder keyPairId(@Nullable String keyPairId) {
            this.keyPairId = keyPairId;
            return this;
        }

        @CustomType.Setter
        public Builder keyType(String keyType) {
            this.keyType = Objects.requireNonNull(keyType);
            return this;
        }

        @CustomType.Setter
        public Builder publicKey(String publicKey) {
            this.publicKey = Objects.requireNonNull(publicKey);
            return this;
        }

        @CustomType.Setter
        public Builder tags(Map<String, String> tags) {
            this.tags = Objects.requireNonNull(tags);
            return this;
        }

        public GetKeyPairResult build() {
            GetKeyPairResult o = new GetKeyPairResult();
            o.arn = this.arn;
            o.createTime = this.createTime;
            o.filters = this.filters;
            o.fingerprint = this.fingerprint;
            o.id = this.id;
            o.includePublicKey = this.includePublicKey;
            o.keyName = this.keyName;
            o.keyPairId = this.keyPairId;
            o.keyType = this.keyType;
            o.publicKey = this.publicKey;
            o.tags = this.tags;
            return o;
        }
    }
}

