/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.ec2.outputs;

import com.pulumi.aws.ec2.outputs.GetPrefixListFilter;
import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class GetPrefixListResult {
    private List<String> cidrBlocks;
    @Nullable
    private List<GetPrefixListFilter> filters;
    private String id;
    private String name;
    @Nullable
    private String prefixListId;

    private GetPrefixListResult() {
    }

    public List<String> cidrBlocks() {
        return this.cidrBlocks;
    }

    public List<GetPrefixListFilter> filters() {
        return this.filters == null ? List.of() : this.filters;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public Optional<String> prefixListId() {
        return Optional.ofNullable(this.prefixListId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GetPrefixListResult defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private List<String> cidrBlocks;
        @Nullable
        private List<GetPrefixListFilter> filters;
        private String id;
        private String name;
        @Nullable
        private String prefixListId;

        public Builder() {
        }

        public Builder(GetPrefixListResult defaults) {
            Objects.requireNonNull(defaults);
            this.cidrBlocks = defaults.cidrBlocks;
            this.filters = defaults.filters;
            this.id = defaults.id;
            this.name = defaults.name;
            this.prefixListId = defaults.prefixListId;
        }

        @CustomType.Setter
        public Builder cidrBlocks(List<String> cidrBlocks) {
            this.cidrBlocks = Objects.requireNonNull(cidrBlocks);
            return this;
        }

        public Builder cidrBlocks(String ... cidrBlocks) {
            return this.cidrBlocks(List.of(cidrBlocks));
        }

        @CustomType.Setter
        public Builder filters(@Nullable List<GetPrefixListFilter> filters) {
            this.filters = filters;
            return this;
        }

        public Builder filters(GetPrefixListFilter ... filters) {
            return this.filters(List.of(filters));
        }

        @CustomType.Setter
        public Builder id(String id) {
            this.id = Objects.requireNonNull(id);
            return this;
        }

        @CustomType.Setter
        public Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        @CustomType.Setter
        public Builder prefixListId(@Nullable String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public GetPrefixListResult build() {
            GetPrefixListResult o = new GetPrefixListResult();
            o.cidrBlocks = this.cidrBlocks;
            o.filters = this.filters;
            o.id = this.id;
            o.name = this.name;
            o.prefixListId = this.prefixListId;
            return o;
        }
    }
}

