/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.ec2.outputs;

import com.pulumi.aws.ec2.outputs.GetVpcEndpointServiceFilter;
import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class GetVpcEndpointServiceResult {
    private Boolean acceptanceRequired;
    private String arn;
    private List<String> availabilityZones;
    private List<String> baseEndpointDnsNames;
    @Nullable
    private List<GetVpcEndpointServiceFilter> filters;
    private String id;
    private Boolean managesVpcEndpoints;
    private String owner;
    private String privateDnsName;
    @Nullable
    private String service;
    private String serviceId;
    private String serviceName;
    private String serviceType;
    private List<String> supportedIpAddressTypes;
    private Map<String, String> tags;
    private Boolean vpcEndpointPolicySupported;

    private GetVpcEndpointServiceResult() {
    }

    public Boolean acceptanceRequired() {
        return this.acceptanceRequired;
    }

    public String arn() {
        return this.arn;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public List<String> baseEndpointDnsNames() {
        return this.baseEndpointDnsNames;
    }

    public List<GetVpcEndpointServiceFilter> filters() {
        return this.filters == null ? List.of() : this.filters;
    }

    public String id() {
        return this.id;
    }

    public Boolean managesVpcEndpoints() {
        return this.managesVpcEndpoints;
    }

    public String owner() {
        return this.owner;
    }

    public String privateDnsName() {
        return this.privateDnsName;
    }

    public Optional<String> service() {
        return Optional.ofNullable(this.service);
    }

    public String serviceId() {
        return this.serviceId;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public String serviceType() {
        return this.serviceType;
    }

    public List<String> supportedIpAddressTypes() {
        return this.supportedIpAddressTypes;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Boolean vpcEndpointPolicySupported() {
        return this.vpcEndpointPolicySupported;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GetVpcEndpointServiceResult defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private Boolean acceptanceRequired;
        private String arn;
        private List<String> availabilityZones;
        private List<String> baseEndpointDnsNames;
        @Nullable
        private List<GetVpcEndpointServiceFilter> filters;
        private String id;
        private Boolean managesVpcEndpoints;
        private String owner;
        private String privateDnsName;
        @Nullable
        private String service;
        private String serviceId;
        private String serviceName;
        private String serviceType;
        private List<String> supportedIpAddressTypes;
        private Map<String, String> tags;
        private Boolean vpcEndpointPolicySupported;

        public Builder() {
        }

        public Builder(GetVpcEndpointServiceResult defaults) {
            Objects.requireNonNull(defaults);
            this.acceptanceRequired = defaults.acceptanceRequired;
            this.arn = defaults.arn;
            this.availabilityZones = defaults.availabilityZones;
            this.baseEndpointDnsNames = defaults.baseEndpointDnsNames;
            this.filters = defaults.filters;
            this.id = defaults.id;
            this.managesVpcEndpoints = defaults.managesVpcEndpoints;
            this.owner = defaults.owner;
            this.privateDnsName = defaults.privateDnsName;
            this.service = defaults.service;
            this.serviceId = defaults.serviceId;
            this.serviceName = defaults.serviceName;
            this.serviceType = defaults.serviceType;
            this.supportedIpAddressTypes = defaults.supportedIpAddressTypes;
            this.tags = defaults.tags;
            this.vpcEndpointPolicySupported = defaults.vpcEndpointPolicySupported;
        }

        @CustomType.Setter
        public Builder acceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = Objects.requireNonNull(acceptanceRequired);
            return this;
        }

        @CustomType.Setter
        public Builder arn(String arn) {
            this.arn = Objects.requireNonNull(arn);
            return this;
        }

        @CustomType.Setter
        public Builder availabilityZones(List<String> availabilityZones) {
            this.availabilityZones = Objects.requireNonNull(availabilityZones);
            return this;
        }

        public Builder availabilityZones(String ... availabilityZones) {
            return this.availabilityZones(List.of(availabilityZones));
        }

        @CustomType.Setter
        public Builder baseEndpointDnsNames(List<String> baseEndpointDnsNames) {
            this.baseEndpointDnsNames = Objects.requireNonNull(baseEndpointDnsNames);
            return this;
        }

        public Builder baseEndpointDnsNames(String ... baseEndpointDnsNames) {
            return this.baseEndpointDnsNames(List.of(baseEndpointDnsNames));
        }

        @CustomType.Setter
        public Builder filters(@Nullable List<GetVpcEndpointServiceFilter> filters) {
            this.filters = filters;
            return this;
        }

        public Builder filters(GetVpcEndpointServiceFilter ... filters) {
            return this.filters(List.of(filters));
        }

        @CustomType.Setter
        public Builder id(String id) {
            this.id = Objects.requireNonNull(id);
            return this;
        }

        @CustomType.Setter
        public Builder managesVpcEndpoints(Boolean managesVpcEndpoints) {
            this.managesVpcEndpoints = Objects.requireNonNull(managesVpcEndpoints);
            return this;
        }

        @CustomType.Setter
        public Builder owner(String owner) {
            this.owner = Objects.requireNonNull(owner);
            return this;
        }

        @CustomType.Setter
        public Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = Objects.requireNonNull(privateDnsName);
            return this;
        }

        @CustomType.Setter
        public Builder service(@Nullable String service) {
            this.service = service;
            return this;
        }

        @CustomType.Setter
        public Builder serviceId(String serviceId) {
            this.serviceId = Objects.requireNonNull(serviceId);
            return this;
        }

        @CustomType.Setter
        public Builder serviceName(String serviceName) {
            this.serviceName = Objects.requireNonNull(serviceName);
            return this;
        }

        @CustomType.Setter
        public Builder serviceType(String serviceType) {
            this.serviceType = Objects.requireNonNull(serviceType);
            return this;
        }

        @CustomType.Setter
        public Builder supportedIpAddressTypes(List<String> supportedIpAddressTypes) {
            this.supportedIpAddressTypes = Objects.requireNonNull(supportedIpAddressTypes);
            return this;
        }

        public Builder supportedIpAddressTypes(String ... supportedIpAddressTypes) {
            return this.supportedIpAddressTypes(List.of(supportedIpAddressTypes));
        }

        @CustomType.Setter
        public Builder tags(Map<String, String> tags) {
            this.tags = Objects.requireNonNull(tags);
            return this;
        }

        @CustomType.Setter
        public Builder vpcEndpointPolicySupported(Boolean vpcEndpointPolicySupported) {
            this.vpcEndpointPolicySupported = Objects.requireNonNull(vpcEndpointPolicySupported);
            return this;
        }

        public GetVpcEndpointServiceResult build() {
            GetVpcEndpointServiceResult o = new GetVpcEndpointServiceResult();
            o.acceptanceRequired = this.acceptanceRequired;
            o.arn = this.arn;
            o.availabilityZones = this.availabilityZones;
            o.baseEndpointDnsNames = this.baseEndpointDnsNames;
            o.filters = this.filters;
            o.id = this.id;
            o.managesVpcEndpoints = this.managesVpcEndpoints;
            o.owner = this.owner;
            o.privateDnsName = this.privateDnsName;
            o.service = this.service;
            o.serviceId = this.serviceId;
            o.serviceName = this.serviceName;
            o.serviceType = this.serviceType;
            o.supportedIpAddressTypes = this.supportedIpAddressTypes;
            o.tags = this.tags;
            o.vpcEndpointPolicySupported = this.vpcEndpointPolicySupported;
            return o;
        }
    }
}

