/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.ec2.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class LaunchTemplateTagSpecification {
    @Nullable
    private String resourceType;
    @Nullable
    private Map<String, String> tags;

    private LaunchTemplateTagSpecification() {
    }

    public Optional<String> resourceType() {
        return Optional.ofNullable(this.resourceType);
    }

    public Map<String, String> tags() {
        return this.tags == null ? Map.of() : this.tags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(LaunchTemplateTagSpecification defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String resourceType;
        @Nullable
        private Map<String, String> tags;

        public Builder() {
        }

        public Builder(LaunchTemplateTagSpecification defaults) {
            Objects.requireNonNull(defaults);
            this.resourceType = defaults.resourceType;
            this.tags = defaults.tags;
        }

        @CustomType.Setter
        public Builder resourceType(@Nullable String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @CustomType.Setter
        public Builder tags(@Nullable Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public LaunchTemplateTagSpecification build() {
            LaunchTemplateTagSpecification o = new LaunchTemplateTagSpecification();
            o.resourceType = this.resourceType;
            o.tags = this.tags;
            return o;
        }
    }
}

