/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.ec2.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class SpotInstanceRequestMetadataOptions {
    @Nullable
    private String httpEndpoint;
    @Nullable
    private String httpProtocolIpv6;
    @Nullable
    private Integer httpPutResponseHopLimit;
    @Nullable
    private String httpTokens;
    @Nullable
    private String instanceMetadataTags;

    private SpotInstanceRequestMetadataOptions() {
    }

    public Optional<String> httpEndpoint() {
        return Optional.ofNullable(this.httpEndpoint);
    }

    public Optional<String> httpProtocolIpv6() {
        return Optional.ofNullable(this.httpProtocolIpv6);
    }

    public Optional<Integer> httpPutResponseHopLimit() {
        return Optional.ofNullable(this.httpPutResponseHopLimit);
    }

    public Optional<String> httpTokens() {
        return Optional.ofNullable(this.httpTokens);
    }

    public Optional<String> instanceMetadataTags() {
        return Optional.ofNullable(this.instanceMetadataTags);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SpotInstanceRequestMetadataOptions defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String httpEndpoint;
        @Nullable
        private String httpProtocolIpv6;
        @Nullable
        private Integer httpPutResponseHopLimit;
        @Nullable
        private String httpTokens;
        @Nullable
        private String instanceMetadataTags;

        public Builder() {
        }

        public Builder(SpotInstanceRequestMetadataOptions defaults) {
            Objects.requireNonNull(defaults);
            this.httpEndpoint = defaults.httpEndpoint;
            this.httpProtocolIpv6 = defaults.httpProtocolIpv6;
            this.httpPutResponseHopLimit = defaults.httpPutResponseHopLimit;
            this.httpTokens = defaults.httpTokens;
            this.instanceMetadataTags = defaults.instanceMetadataTags;
        }

        @CustomType.Setter
        public Builder httpEndpoint(@Nullable String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
            return this;
        }

        @CustomType.Setter
        public Builder httpProtocolIpv6(@Nullable String httpProtocolIpv6) {
            this.httpProtocolIpv6 = httpProtocolIpv6;
            return this;
        }

        @CustomType.Setter
        public Builder httpPutResponseHopLimit(@Nullable Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
            return this;
        }

        @CustomType.Setter
        public Builder httpTokens(@Nullable String httpTokens) {
            this.httpTokens = httpTokens;
            return this;
        }

        @CustomType.Setter
        public Builder instanceMetadataTags(@Nullable String instanceMetadataTags) {
            this.instanceMetadataTags = instanceMetadataTags;
            return this;
        }

        public SpotInstanceRequestMetadataOptions build() {
            SpotInstanceRequestMetadataOptions o = new SpotInstanceRequestMetadataOptions();
            o.httpEndpoint = this.httpEndpoint;
            o.httpProtocolIpv6 = this.httpProtocolIpv6;
            o.httpPutResponseHopLimit = this.httpPutResponseHopLimit;
            o.httpTokens = this.httpTokens;
            o.instanceMetadataTags = this.instanceMetadataTags;
            return o;
        }
    }
}

