/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.ec2.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class VpcEndpointDnsOptions {
    @Nullable
    private String dnsRecordIpType;
    @Nullable
    private Boolean privateDnsOnlyForInboundResolverEndpoint;

    private VpcEndpointDnsOptions() {
    }

    public Optional<String> dnsRecordIpType() {
        return Optional.ofNullable(this.dnsRecordIpType);
    }

    public Optional<Boolean> privateDnsOnlyForInboundResolverEndpoint() {
        return Optional.ofNullable(this.privateDnsOnlyForInboundResolverEndpoint);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(VpcEndpointDnsOptions defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String dnsRecordIpType;
        @Nullable
        private Boolean privateDnsOnlyForInboundResolverEndpoint;

        public Builder() {
        }

        public Builder(VpcEndpointDnsOptions defaults) {
            Objects.requireNonNull(defaults);
            this.dnsRecordIpType = defaults.dnsRecordIpType;
            this.privateDnsOnlyForInboundResolverEndpoint = defaults.privateDnsOnlyForInboundResolverEndpoint;
        }

        @CustomType.Setter
        public Builder dnsRecordIpType(@Nullable String dnsRecordIpType) {
            this.dnsRecordIpType = dnsRecordIpType;
            return this;
        }

        @CustomType.Setter
        public Builder privateDnsOnlyForInboundResolverEndpoint(@Nullable Boolean privateDnsOnlyForInboundResolverEndpoint) {
            this.privateDnsOnlyForInboundResolverEndpoint = privateDnsOnlyForInboundResolverEndpoint;
            return this;
        }

        public VpcEndpointDnsOptions build() {
            VpcEndpointDnsOptions o = new VpcEndpointDnsOptions();
            o.dnsRecordIpType = this.dnsRecordIpType;
            o.privateDnsOnlyForInboundResolverEndpoint = this.privateDnsOnlyForInboundResolverEndpoint;
            return o;
        }
    }
}

