/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.ec2clientvpn.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class EndpointConnectionLogOptions {
    @Nullable
    private String cloudwatchLogGroup;
    @Nullable
    private String cloudwatchLogStream;
    private Boolean enabled;

    private EndpointConnectionLogOptions() {
    }

    public Optional<String> cloudwatchLogGroup() {
        return Optional.ofNullable(this.cloudwatchLogGroup);
    }

    public Optional<String> cloudwatchLogStream() {
        return Optional.ofNullable(this.cloudwatchLogStream);
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(EndpointConnectionLogOptions defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String cloudwatchLogGroup;
        @Nullable
        private String cloudwatchLogStream;
        private Boolean enabled;

        public Builder() {
        }

        public Builder(EndpointConnectionLogOptions defaults) {
            Objects.requireNonNull(defaults);
            this.cloudwatchLogGroup = defaults.cloudwatchLogGroup;
            this.cloudwatchLogStream = defaults.cloudwatchLogStream;
            this.enabled = defaults.enabled;
        }

        @CustomType.Setter
        public Builder cloudwatchLogGroup(@Nullable String cloudwatchLogGroup) {
            this.cloudwatchLogGroup = cloudwatchLogGroup;
            return this;
        }

        @CustomType.Setter
        public Builder cloudwatchLogStream(@Nullable String cloudwatchLogStream) {
            this.cloudwatchLogStream = cloudwatchLogStream;
            return this;
        }

        @CustomType.Setter
        public Builder enabled(Boolean enabled) {
            this.enabled = Objects.requireNonNull(enabled);
            return this;
        }

        public EndpointConnectionLogOptions build() {
            EndpointConnectionLogOptions o = new EndpointConnectionLogOptions();
            o.cloudwatchLogGroup = this.cloudwatchLogGroup;
            o.cloudwatchLogStream = this.cloudwatchLogStream;
            o.enabled = this.enabled;
            return o;
        }
    }
}

