/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.ecs.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class TaskDefinitionProxyConfiguration {
    private String containerName;
    @Nullable
    private Map<String, String> properties;
    @Nullable
    private String type;

    private TaskDefinitionProxyConfiguration() {
    }

    public String containerName() {
        return this.containerName;
    }

    public Map<String, String> properties() {
        return this.properties == null ? Map.of() : this.properties;
    }

    public Optional<String> type() {
        return Optional.ofNullable(this.type);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TaskDefinitionProxyConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String containerName;
        @Nullable
        private Map<String, String> properties;
        @Nullable
        private String type;

        public Builder() {
        }

        public Builder(TaskDefinitionProxyConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.containerName = defaults.containerName;
            this.properties = defaults.properties;
            this.type = defaults.type;
        }

        @CustomType.Setter
        public Builder containerName(String containerName) {
            this.containerName = Objects.requireNonNull(containerName);
            return this;
        }

        @CustomType.Setter
        public Builder properties(@Nullable Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        @CustomType.Setter
        public Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        public TaskDefinitionProxyConfiguration build() {
            TaskDefinitionProxyConfiguration o = new TaskDefinitionProxyConfiguration();
            o.containerName = this.containerName;
            o.properties = this.properties;
            o.type = this.type;
            return o;
        }
    }
}

