/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.efs;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.efs.FileSystemArgs;
import com.pulumi.aws.efs.inputs.FileSystemState;
import com.pulumi.aws.efs.outputs.FileSystemLifecyclePolicy;
import com.pulumi.aws.efs.outputs.FileSystemSizeInByte;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.resources.CustomResource;
import com.pulumi.resources.CustomResourceOptions;
import com.pulumi.resources.ResourceArgs;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

@ResourceType(type="aws:efs/fileSystem:FileSystem")
public class FileSystem
extends CustomResource {
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;
    @Export(name="availabilityZoneId", refs={String.class}, tree="[0]")
    private Output<String> availabilityZoneId;
    @Export(name="availabilityZoneName", refs={String.class}, tree="[0]")
    private Output<String> availabilityZoneName;
    @Export(name="creationToken", refs={String.class}, tree="[0]")
    private Output<String> creationToken;
    @Export(name="dnsName", refs={String.class}, tree="[0]")
    private Output<String> dnsName;
    @Export(name="encrypted", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> encrypted;
    @Export(name="kmsKeyId", refs={String.class}, tree="[0]")
    private Output<String> kmsKeyId;
    @Export(name="lifecyclePolicies", refs={List.class, FileSystemLifecyclePolicy.class}, tree="[0,1]")
    private Output<List<FileSystemLifecyclePolicy>> lifecyclePolicies;
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;
    @Export(name="numberOfMountTargets", refs={Integer.class}, tree="[0]")
    private Output<Integer> numberOfMountTargets;
    @Export(name="ownerId", refs={String.class}, tree="[0]")
    private Output<String> ownerId;
    @Export(name="performanceMode", refs={String.class}, tree="[0]")
    private Output<String> performanceMode;
    @Export(name="provisionedThroughputInMibps", refs={Double.class}, tree="[0]")
    private Output<Double> provisionedThroughputInMibps;
    @Export(name="sizeInBytes", refs={List.class, FileSystemSizeInByte.class}, tree="[0,1]")
    private Output<List<FileSystemSizeInByte>> sizeInBytes;
    @Export(name="tags", refs={Map.class, String.class}, tree="[0,1,1]")
    private Output<Map<String, String>> tags;
    @Deprecated
    @Export(name="tagsAll", refs={Map.class, String.class}, tree="[0,1,1]")
    private Output<Map<String, String>> tagsAll;
    @Export(name="throughputMode", refs={String.class}, tree="[0]")
    private Output<String> throughputMode;

    public Output<String> arn() {
        return this.arn;
    }

    public Output<String> availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public Output<String> availabilityZoneName() {
        return this.availabilityZoneName;
    }

    public Output<String> creationToken() {
        return this.creationToken;
    }

    public Output<String> dnsName() {
        return this.dnsName;
    }

    public Output<Boolean> encrypted() {
        return this.encrypted;
    }

    public Output<String> kmsKeyId() {
        return this.kmsKeyId;
    }

    public Output<Optional<List<FileSystemLifecyclePolicy>>> lifecyclePolicies() {
        return Codegen.optional(this.lifecyclePolicies);
    }

    public Output<String> name() {
        return this.name;
    }

    public Output<Integer> numberOfMountTargets() {
        return this.numberOfMountTargets;
    }

    public Output<String> ownerId() {
        return this.ownerId;
    }

    public Output<String> performanceMode() {
        return this.performanceMode;
    }

    public Output<Optional<Double>> provisionedThroughputInMibps() {
        return Codegen.optional(this.provisionedThroughputInMibps);
    }

    public Output<List<FileSystemSizeInByte>> sizeInBytes() {
        return this.sizeInBytes;
    }

    public Output<Optional<Map<String, String>>> tags() {
        return Codegen.optional(this.tags);
    }

    public Output<Map<String, String>> tagsAll() {
        return this.tagsAll;
    }

    public Output<Optional<String>> throughputMode() {
        return Codegen.optional(this.throughputMode);
    }

    public FileSystem(String name) {
        this(name, FileSystemArgs.Empty);
    }

    public FileSystem(String name, @Nullable FileSystemArgs args) {
        this(name, args, null);
    }

    public FileSystem(String name, @Nullable FileSystemArgs args, @Nullable CustomResourceOptions options) {
        super("aws:efs/fileSystem:FileSystem", name, (ResourceArgs)(args == null ? FileSystemArgs.Empty : args), FileSystem.makeResourceOptions(options, (Output<String>)Codegen.empty()));
    }

    private FileSystem(String name, Output<String> id, @Nullable FileSystemState state, @Nullable CustomResourceOptions options) {
        super("aws:efs/fileSystem:FileSystem", name, (ResourceArgs)state, FileSystem.makeResourceOptions(options, id));
    }

    private static CustomResourceOptions makeResourceOptions(@Nullable CustomResourceOptions options, @Nullable Output<String> id) {
        CustomResourceOptions defaultOptions = ((CustomResourceOptions.Builder)CustomResourceOptions.builder().version(Utilities.getVersion())).additionalSecretOutputs(List.of("tagsAll")).build();
        return CustomResourceOptions.merge((CustomResourceOptions)defaultOptions, (CustomResourceOptions)options, id);
    }

    public static FileSystem get(String name, Output<String> id, @Nullable FileSystemState state, @Nullable CustomResourceOptions options) {
        return new FileSystem(name, id, state, options);
    }
}

