/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.eks.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.resources.ResourceArgs;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ClusterVpcConfigArgs
extends ResourceArgs {
    public static final ClusterVpcConfigArgs Empty = new ClusterVpcConfigArgs();
    @Import(name="clusterSecurityGroupId")
    @Nullable
    private Output<String> clusterSecurityGroupId;
    @Import(name="endpointPrivateAccess")
    @Nullable
    private Output<Boolean> endpointPrivateAccess;
    @Import(name="endpointPublicAccess")
    @Nullable
    private Output<Boolean> endpointPublicAccess;
    @Import(name="publicAccessCidrs")
    @Nullable
    private Output<List<String>> publicAccessCidrs;
    @Import(name="securityGroupIds")
    @Nullable
    private Output<List<String>> securityGroupIds;
    @Import(name="subnetIds", required=true)
    private Output<List<String>> subnetIds;
    @Import(name="vpcId")
    @Nullable
    private Output<String> vpcId;

    public Optional<Output<String>> clusterSecurityGroupId() {
        return Optional.ofNullable(this.clusterSecurityGroupId);
    }

    public Optional<Output<Boolean>> endpointPrivateAccess() {
        return Optional.ofNullable(this.endpointPrivateAccess);
    }

    public Optional<Output<Boolean>> endpointPublicAccess() {
        return Optional.ofNullable(this.endpointPublicAccess);
    }

    public Optional<Output<List<String>>> publicAccessCidrs() {
        return Optional.ofNullable(this.publicAccessCidrs);
    }

    public Optional<Output<List<String>>> securityGroupIds() {
        return Optional.ofNullable(this.securityGroupIds);
    }

    public Output<List<String>> subnetIds() {
        return this.subnetIds;
    }

    public Optional<Output<String>> vpcId() {
        return Optional.ofNullable(this.vpcId);
    }

    private ClusterVpcConfigArgs() {
    }

    private ClusterVpcConfigArgs(ClusterVpcConfigArgs $) {
        this.clusterSecurityGroupId = $.clusterSecurityGroupId;
        this.endpointPrivateAccess = $.endpointPrivateAccess;
        this.endpointPublicAccess = $.endpointPublicAccess;
        this.publicAccessCidrs = $.publicAccessCidrs;
        this.securityGroupIds = $.securityGroupIds;
        this.subnetIds = $.subnetIds;
        this.vpcId = $.vpcId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClusterVpcConfigArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ClusterVpcConfigArgs $;

        public Builder() {
            this.$ = new ClusterVpcConfigArgs();
        }

        public Builder(ClusterVpcConfigArgs defaults) {
            this.$ = new ClusterVpcConfigArgs(Objects.requireNonNull(defaults));
        }

        public Builder clusterSecurityGroupId(@Nullable Output<String> clusterSecurityGroupId) {
            this.$.clusterSecurityGroupId = clusterSecurityGroupId;
            return this;
        }

        public Builder clusterSecurityGroupId(String clusterSecurityGroupId) {
            return this.clusterSecurityGroupId((Output<String>)Output.of((Object)clusterSecurityGroupId));
        }

        public Builder endpointPrivateAccess(@Nullable Output<Boolean> endpointPrivateAccess) {
            this.$.endpointPrivateAccess = endpointPrivateAccess;
            return this;
        }

        public Builder endpointPrivateAccess(Boolean endpointPrivateAccess) {
            return this.endpointPrivateAccess((Output<Boolean>)Output.of((Object)endpointPrivateAccess));
        }

        public Builder endpointPublicAccess(@Nullable Output<Boolean> endpointPublicAccess) {
            this.$.endpointPublicAccess = endpointPublicAccess;
            return this;
        }

        public Builder endpointPublicAccess(Boolean endpointPublicAccess) {
            return this.endpointPublicAccess((Output<Boolean>)Output.of((Object)endpointPublicAccess));
        }

        public Builder publicAccessCidrs(@Nullable Output<List<String>> publicAccessCidrs) {
            this.$.publicAccessCidrs = publicAccessCidrs;
            return this;
        }

        public Builder publicAccessCidrs(List<String> publicAccessCidrs) {
            return this.publicAccessCidrs((Output<List<String>>)Output.of(publicAccessCidrs));
        }

        public Builder publicAccessCidrs(String ... publicAccessCidrs) {
            return this.publicAccessCidrs(List.of(publicAccessCidrs));
        }

        public Builder securityGroupIds(@Nullable Output<List<String>> securityGroupIds) {
            this.$.securityGroupIds = securityGroupIds;
            return this;
        }

        public Builder securityGroupIds(List<String> securityGroupIds) {
            return this.securityGroupIds((Output<List<String>>)Output.of(securityGroupIds));
        }

        public Builder securityGroupIds(String ... securityGroupIds) {
            return this.securityGroupIds(List.of(securityGroupIds));
        }

        public Builder subnetIds(Output<List<String>> subnetIds) {
            this.$.subnetIds = subnetIds;
            return this;
        }

        public Builder subnetIds(List<String> subnetIds) {
            return this.subnetIds((Output<List<String>>)Output.of(subnetIds));
        }

        public Builder subnetIds(String ... subnetIds) {
            return this.subnetIds(List.of(subnetIds));
        }

        public Builder vpcId(@Nullable Output<String> vpcId) {
            this.$.vpcId = vpcId;
            return this;
        }

        public Builder vpcId(String vpcId) {
            return this.vpcId((Output<String>)Output.of((Object)vpcId));
        }

        public ClusterVpcConfigArgs build() {
            this.$.subnetIds = Objects.requireNonNull(this.$.subnetIds, "expected parameter 'subnetIds' to be non-null");
            return this.$;
        }
    }
}

