/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.eks.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ClusterVpcConfig {
    @Nullable
    private String clusterSecurityGroupId;
    @Nullable
    private Boolean endpointPrivateAccess;
    @Nullable
    private Boolean endpointPublicAccess;
    @Nullable
    private List<String> publicAccessCidrs;
    @Nullable
    private List<String> securityGroupIds;
    private List<String> subnetIds;
    @Nullable
    private String vpcId;

    private ClusterVpcConfig() {
    }

    public Optional<String> clusterSecurityGroupId() {
        return Optional.ofNullable(this.clusterSecurityGroupId);
    }

    public Optional<Boolean> endpointPrivateAccess() {
        return Optional.ofNullable(this.endpointPrivateAccess);
    }

    public Optional<Boolean> endpointPublicAccess() {
        return Optional.ofNullable(this.endpointPublicAccess);
    }

    public List<String> publicAccessCidrs() {
        return this.publicAccessCidrs == null ? List.of() : this.publicAccessCidrs;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds == null ? List.of() : this.securityGroupIds;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public Optional<String> vpcId() {
        return Optional.ofNullable(this.vpcId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClusterVpcConfig defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String clusterSecurityGroupId;
        @Nullable
        private Boolean endpointPrivateAccess;
        @Nullable
        private Boolean endpointPublicAccess;
        @Nullable
        private List<String> publicAccessCidrs;
        @Nullable
        private List<String> securityGroupIds;
        private List<String> subnetIds;
        @Nullable
        private String vpcId;

        public Builder() {
        }

        public Builder(ClusterVpcConfig defaults) {
            Objects.requireNonNull(defaults);
            this.clusterSecurityGroupId = defaults.clusterSecurityGroupId;
            this.endpointPrivateAccess = defaults.endpointPrivateAccess;
            this.endpointPublicAccess = defaults.endpointPublicAccess;
            this.publicAccessCidrs = defaults.publicAccessCidrs;
            this.securityGroupIds = defaults.securityGroupIds;
            this.subnetIds = defaults.subnetIds;
            this.vpcId = defaults.vpcId;
        }

        @CustomType.Setter
        public Builder clusterSecurityGroupId(@Nullable String clusterSecurityGroupId) {
            this.clusterSecurityGroupId = clusterSecurityGroupId;
            return this;
        }

        @CustomType.Setter
        public Builder endpointPrivateAccess(@Nullable Boolean endpointPrivateAccess) {
            this.endpointPrivateAccess = endpointPrivateAccess;
            return this;
        }

        @CustomType.Setter
        public Builder endpointPublicAccess(@Nullable Boolean endpointPublicAccess) {
            this.endpointPublicAccess = endpointPublicAccess;
            return this;
        }

        @CustomType.Setter
        public Builder publicAccessCidrs(@Nullable List<String> publicAccessCidrs) {
            this.publicAccessCidrs = publicAccessCidrs;
            return this;
        }

        public Builder publicAccessCidrs(String ... publicAccessCidrs) {
            return this.publicAccessCidrs(List.of(publicAccessCidrs));
        }

        @CustomType.Setter
        public Builder securityGroupIds(@Nullable List<String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
            return this;
        }

        public Builder securityGroupIds(String ... securityGroupIds) {
            return this.securityGroupIds(List.of(securityGroupIds));
        }

        @CustomType.Setter
        public Builder subnetIds(List<String> subnetIds) {
            this.subnetIds = Objects.requireNonNull(subnetIds);
            return this;
        }

        public Builder subnetIds(String ... subnetIds) {
            return this.subnetIds(List.of(subnetIds));
        }

        @CustomType.Setter
        public Builder vpcId(@Nullable String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public ClusterVpcConfig build() {
            ClusterVpcConfig o = new ClusterVpcConfig();
            o.clusterSecurityGroupId = this.clusterSecurityGroupId;
            o.endpointPrivateAccess = this.endpointPrivateAccess;
            o.endpointPublicAccess = this.endpointPublicAccess;
            o.publicAccessCidrs = this.publicAccessCidrs;
            o.securityGroupIds = this.securityGroupIds;
            o.subnetIds = this.subnetIds;
            o.vpcId = this.vpcId;
            return o;
        }
    }
}

