/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.eks.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class NodeGroupRemoteAccess {
    @Nullable
    private String ec2SshKey;
    @Nullable
    private List<String> sourceSecurityGroupIds;

    private NodeGroupRemoteAccess() {
    }

    public Optional<String> ec2SshKey() {
        return Optional.ofNullable(this.ec2SshKey);
    }

    public List<String> sourceSecurityGroupIds() {
        return this.sourceSecurityGroupIds == null ? List.of() : this.sourceSecurityGroupIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(NodeGroupRemoteAccess defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String ec2SshKey;
        @Nullable
        private List<String> sourceSecurityGroupIds;

        public Builder() {
        }

        public Builder(NodeGroupRemoteAccess defaults) {
            Objects.requireNonNull(defaults);
            this.ec2SshKey = defaults.ec2SshKey;
            this.sourceSecurityGroupIds = defaults.sourceSecurityGroupIds;
        }

        @CustomType.Setter
        public Builder ec2SshKey(@Nullable String ec2SshKey) {
            this.ec2SshKey = ec2SshKey;
            return this;
        }

        @CustomType.Setter
        public Builder sourceSecurityGroupIds(@Nullable List<String> sourceSecurityGroupIds) {
            this.sourceSecurityGroupIds = sourceSecurityGroupIds;
            return this;
        }

        public Builder sourceSecurityGroupIds(String ... sourceSecurityGroupIds) {
            return this.sourceSecurityGroupIds(List.of(sourceSecurityGroupIds));
        }

        public NodeGroupRemoteAccess build() {
            NodeGroupRemoteAccess o = new NodeGroupRemoteAccess();
            o.ec2SshKey = this.ec2SshKey;
            o.sourceSecurityGroupIds = this.sourceSecurityGroupIds;
            return o;
        }
    }
}

