/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.elasticsearch.outputs;

import com.pulumi.aws.elasticsearch.outputs.DomainAutoTuneOptionsMaintenanceSchedule;
import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class DomainAutoTuneOptions {
    private String desiredState;
    @Nullable
    private List<DomainAutoTuneOptionsMaintenanceSchedule> maintenanceSchedules;
    @Nullable
    private String rollbackOnDisable;

    private DomainAutoTuneOptions() {
    }

    public String desiredState() {
        return this.desiredState;
    }

    public List<DomainAutoTuneOptionsMaintenanceSchedule> maintenanceSchedules() {
        return this.maintenanceSchedules == null ? List.of() : this.maintenanceSchedules;
    }

    public Optional<String> rollbackOnDisable() {
        return Optional.ofNullable(this.rollbackOnDisable);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DomainAutoTuneOptions defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String desiredState;
        @Nullable
        private List<DomainAutoTuneOptionsMaintenanceSchedule> maintenanceSchedules;
        @Nullable
        private String rollbackOnDisable;

        public Builder() {
        }

        public Builder(DomainAutoTuneOptions defaults) {
            Objects.requireNonNull(defaults);
            this.desiredState = defaults.desiredState;
            this.maintenanceSchedules = defaults.maintenanceSchedules;
            this.rollbackOnDisable = defaults.rollbackOnDisable;
        }

        @CustomType.Setter
        public Builder desiredState(String desiredState) {
            this.desiredState = Objects.requireNonNull(desiredState);
            return this;
        }

        @CustomType.Setter
        public Builder maintenanceSchedules(@Nullable List<DomainAutoTuneOptionsMaintenanceSchedule> maintenanceSchedules) {
            this.maintenanceSchedules = maintenanceSchedules;
            return this;
        }

        public Builder maintenanceSchedules(DomainAutoTuneOptionsMaintenanceSchedule ... maintenanceSchedules) {
            return this.maintenanceSchedules(List.of(maintenanceSchedules));
        }

        @CustomType.Setter
        public Builder rollbackOnDisable(@Nullable String rollbackOnDisable) {
            this.rollbackOnDisable = rollbackOnDisable;
            return this;
        }

        public DomainAutoTuneOptions build() {
            DomainAutoTuneOptions o = new DomainAutoTuneOptions();
            o.desiredState = this.desiredState;
            o.maintenanceSchedules = this.maintenanceSchedules;
            o.rollbackOnDisable = this.rollbackOnDisable;
            return o;
        }
    }
}

