/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.elasticsearch.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class DomainCognitoOptions {
    @Nullable
    private Boolean enabled;
    private String identityPoolId;
    private String roleArn;
    private String userPoolId;

    private DomainCognitoOptions() {
    }

    public Optional<Boolean> enabled() {
        return Optional.ofNullable(this.enabled);
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DomainCognitoOptions defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Boolean enabled;
        private String identityPoolId;
        private String roleArn;
        private String userPoolId;

        public Builder() {
        }

        public Builder(DomainCognitoOptions defaults) {
            Objects.requireNonNull(defaults);
            this.enabled = defaults.enabled;
            this.identityPoolId = defaults.identityPoolId;
            this.roleArn = defaults.roleArn;
            this.userPoolId = defaults.userPoolId;
        }

        @CustomType.Setter
        public Builder enabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @CustomType.Setter
        public Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = Objects.requireNonNull(identityPoolId);
            return this;
        }

        @CustomType.Setter
        public Builder roleArn(String roleArn) {
            this.roleArn = Objects.requireNonNull(roleArn);
            return this;
        }

        @CustomType.Setter
        public Builder userPoolId(String userPoolId) {
            this.userPoolId = Objects.requireNonNull(userPoolId);
            return this;
        }

        public DomainCognitoOptions build() {
            DomainCognitoOptions o = new DomainCognitoOptions();
            o.enabled = this.enabled;
            o.identityPoolId = this.identityPoolId;
            o.roleArn = this.roleArn;
            o.userPoolId = this.userPoolId;
            return o;
        }
    }
}

