/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.elasticsearch.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class DomainLogPublishingOption {
    private String cloudwatchLogGroupArn;
    @Nullable
    private Boolean enabled;
    private String logType;

    private DomainLogPublishingOption() {
    }

    public String cloudwatchLogGroupArn() {
        return this.cloudwatchLogGroupArn;
    }

    public Optional<Boolean> enabled() {
        return Optional.ofNullable(this.enabled);
    }

    public String logType() {
        return this.logType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DomainLogPublishingOption defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String cloudwatchLogGroupArn;
        @Nullable
        private Boolean enabled;
        private String logType;

        public Builder() {
        }

        public Builder(DomainLogPublishingOption defaults) {
            Objects.requireNonNull(defaults);
            this.cloudwatchLogGroupArn = defaults.cloudwatchLogGroupArn;
            this.enabled = defaults.enabled;
            this.logType = defaults.logType;
        }

        @CustomType.Setter
        public Builder cloudwatchLogGroupArn(String cloudwatchLogGroupArn) {
            this.cloudwatchLogGroupArn = Objects.requireNonNull(cloudwatchLogGroupArn);
            return this;
        }

        @CustomType.Setter
        public Builder enabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @CustomType.Setter
        public Builder logType(String logType) {
            this.logType = Objects.requireNonNull(logType);
            return this;
        }

        public DomainLogPublishingOption build() {
            DomainLogPublishingOption o = new DomainLogPublishingOption();
            o.cloudwatchLogGroupArn = this.cloudwatchLogGroupArn;
            o.enabled = this.enabled;
            o.logType = this.logType;
            return o;
        }
    }
}

