/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.elastictranscoder.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class PipelineNotifications {
    @Nullable
    private String completed;
    @Nullable
    private String error;
    @Nullable
    private String progressing;
    @Nullable
    private String warning;

    private PipelineNotifications() {
    }

    public Optional<String> completed() {
        return Optional.ofNullable(this.completed);
    }

    public Optional<String> error() {
        return Optional.ofNullable(this.error);
    }

    public Optional<String> progressing() {
        return Optional.ofNullable(this.progressing);
    }

    public Optional<String> warning() {
        return Optional.ofNullable(this.warning);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PipelineNotifications defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String completed;
        @Nullable
        private String error;
        @Nullable
        private String progressing;
        @Nullable
        private String warning;

        public Builder() {
        }

        public Builder(PipelineNotifications defaults) {
            Objects.requireNonNull(defaults);
            this.completed = defaults.completed;
            this.error = defaults.error;
            this.progressing = defaults.progressing;
            this.warning = defaults.warning;
        }

        @CustomType.Setter
        public Builder completed(@Nullable String completed) {
            this.completed = completed;
            return this;
        }

        @CustomType.Setter
        public Builder error(@Nullable String error) {
            this.error = error;
            return this;
        }

        @CustomType.Setter
        public Builder progressing(@Nullable String progressing) {
            this.progressing = progressing;
            return this;
        }

        @CustomType.Setter
        public Builder warning(@Nullable String warning) {
            this.warning = warning;
            return this;
        }

        public PipelineNotifications build() {
            PipelineNotifications o = new PipelineNotifications();
            o.completed = this.completed;
            o.error = this.error;
            o.progressing = this.progressing;
            o.warning = this.warning;
            return o;
        }
    }
}

