/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.emr.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ClusterPlacementGroupConfig {
    private String instanceRole;
    @Nullable
    private String placementStrategy;

    private ClusterPlacementGroupConfig() {
    }

    public String instanceRole() {
        return this.instanceRole;
    }

    public Optional<String> placementStrategy() {
        return Optional.ofNullable(this.placementStrategy);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClusterPlacementGroupConfig defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String instanceRole;
        @Nullable
        private String placementStrategy;

        public Builder() {
        }

        public Builder(ClusterPlacementGroupConfig defaults) {
            Objects.requireNonNull(defaults);
            this.instanceRole = defaults.instanceRole;
            this.placementStrategy = defaults.placementStrategy;
        }

        @CustomType.Setter
        public Builder instanceRole(String instanceRole) {
            this.instanceRole = Objects.requireNonNull(instanceRole);
            return this;
        }

        @CustomType.Setter
        public Builder placementStrategy(@Nullable String placementStrategy) {
            this.placementStrategy = placementStrategy;
            return this;
        }

        public ClusterPlacementGroupConfig build() {
            ClusterPlacementGroupConfig o = new ClusterPlacementGroupConfig();
            o.instanceRole = this.instanceRole;
            o.placementStrategy = this.placementStrategy;
            return o;
        }
    }
}

