/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.emr.outputs;

import com.pulumi.aws.emr.outputs.InstanceFleetInstanceTypeConfigConfiguration;
import com.pulumi.aws.emr.outputs.InstanceFleetInstanceTypeConfigEbsConfig;
import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class InstanceFleetInstanceTypeConfig {
    @Nullable
    private String bidPrice;
    @Nullable
    private Double bidPriceAsPercentageOfOnDemandPrice;
    @Nullable
    private List<InstanceFleetInstanceTypeConfigConfiguration> configurations;
    @Nullable
    private List<InstanceFleetInstanceTypeConfigEbsConfig> ebsConfigs;
    private String instanceType;
    @Nullable
    private Integer weightedCapacity;

    private InstanceFleetInstanceTypeConfig() {
    }

    public Optional<String> bidPrice() {
        return Optional.ofNullable(this.bidPrice);
    }

    public Optional<Double> bidPriceAsPercentageOfOnDemandPrice() {
        return Optional.ofNullable(this.bidPriceAsPercentageOfOnDemandPrice);
    }

    public List<InstanceFleetInstanceTypeConfigConfiguration> configurations() {
        return this.configurations == null ? List.of() : this.configurations;
    }

    public List<InstanceFleetInstanceTypeConfigEbsConfig> ebsConfigs() {
        return this.ebsConfigs == null ? List.of() : this.ebsConfigs;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public Optional<Integer> weightedCapacity() {
        return Optional.ofNullable(this.weightedCapacity);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(InstanceFleetInstanceTypeConfig defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String bidPrice;
        @Nullable
        private Double bidPriceAsPercentageOfOnDemandPrice;
        @Nullable
        private List<InstanceFleetInstanceTypeConfigConfiguration> configurations;
        @Nullable
        private List<InstanceFleetInstanceTypeConfigEbsConfig> ebsConfigs;
        private String instanceType;
        @Nullable
        private Integer weightedCapacity;

        public Builder() {
        }

        public Builder(InstanceFleetInstanceTypeConfig defaults) {
            Objects.requireNonNull(defaults);
            this.bidPrice = defaults.bidPrice;
            this.bidPriceAsPercentageOfOnDemandPrice = defaults.bidPriceAsPercentageOfOnDemandPrice;
            this.configurations = defaults.configurations;
            this.ebsConfigs = defaults.ebsConfigs;
            this.instanceType = defaults.instanceType;
            this.weightedCapacity = defaults.weightedCapacity;
        }

        @CustomType.Setter
        public Builder bidPrice(@Nullable String bidPrice) {
            this.bidPrice = bidPrice;
            return this;
        }

        @CustomType.Setter
        public Builder bidPriceAsPercentageOfOnDemandPrice(@Nullable Double bidPriceAsPercentageOfOnDemandPrice) {
            this.bidPriceAsPercentageOfOnDemandPrice = bidPriceAsPercentageOfOnDemandPrice;
            return this;
        }

        @CustomType.Setter
        public Builder configurations(@Nullable List<InstanceFleetInstanceTypeConfigConfiguration> configurations) {
            this.configurations = configurations;
            return this;
        }

        public Builder configurations(InstanceFleetInstanceTypeConfigConfiguration ... configurations) {
            return this.configurations(List.of(configurations));
        }

        @CustomType.Setter
        public Builder ebsConfigs(@Nullable List<InstanceFleetInstanceTypeConfigEbsConfig> ebsConfigs) {
            this.ebsConfigs = ebsConfigs;
            return this;
        }

        public Builder ebsConfigs(InstanceFleetInstanceTypeConfigEbsConfig ... ebsConfigs) {
            return this.ebsConfigs(List.of(ebsConfigs));
        }

        @CustomType.Setter
        public Builder instanceType(String instanceType) {
            this.instanceType = Objects.requireNonNull(instanceType);
            return this;
        }

        @CustomType.Setter
        public Builder weightedCapacity(@Nullable Integer weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
            return this;
        }

        public InstanceFleetInstanceTypeConfig build() {
            InstanceFleetInstanceTypeConfig o = new InstanceFleetInstanceTypeConfig();
            o.bidPrice = this.bidPrice;
            o.bidPriceAsPercentageOfOnDemandPrice = this.bidPriceAsPercentageOfOnDemandPrice;
            o.configurations = this.configurations;
            o.ebsConfigs = this.ebsConfigs;
            o.instanceType = this.instanceType;
            o.weightedCapacity = this.weightedCapacity;
            return o;
        }
    }
}

