/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.finspace.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;

@CustomType
public final class KxClusterAutoScalingConfiguration {
    private String autoScalingMetric;
    private Integer maxNodeCount;
    private Double metricTarget;
    private Integer minNodeCount;
    private Double scaleInCooldownSeconds;
    private Double scaleOutCooldownSeconds;

    private KxClusterAutoScalingConfiguration() {
    }

    public String autoScalingMetric() {
        return this.autoScalingMetric;
    }

    public Integer maxNodeCount() {
        return this.maxNodeCount;
    }

    public Double metricTarget() {
        return this.metricTarget;
    }

    public Integer minNodeCount() {
        return this.minNodeCount;
    }

    public Double scaleInCooldownSeconds() {
        return this.scaleInCooldownSeconds;
    }

    public Double scaleOutCooldownSeconds() {
        return this.scaleOutCooldownSeconds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(KxClusterAutoScalingConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String autoScalingMetric;
        private Integer maxNodeCount;
        private Double metricTarget;
        private Integer minNodeCount;
        private Double scaleInCooldownSeconds;
        private Double scaleOutCooldownSeconds;

        public Builder() {
        }

        public Builder(KxClusterAutoScalingConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.autoScalingMetric = defaults.autoScalingMetric;
            this.maxNodeCount = defaults.maxNodeCount;
            this.metricTarget = defaults.metricTarget;
            this.minNodeCount = defaults.minNodeCount;
            this.scaleInCooldownSeconds = defaults.scaleInCooldownSeconds;
            this.scaleOutCooldownSeconds = defaults.scaleOutCooldownSeconds;
        }

        @CustomType.Setter
        public Builder autoScalingMetric(String autoScalingMetric) {
            this.autoScalingMetric = Objects.requireNonNull(autoScalingMetric);
            return this;
        }

        @CustomType.Setter
        public Builder maxNodeCount(Integer maxNodeCount) {
            this.maxNodeCount = Objects.requireNonNull(maxNodeCount);
            return this;
        }

        @CustomType.Setter
        public Builder metricTarget(Double metricTarget) {
            this.metricTarget = Objects.requireNonNull(metricTarget);
            return this;
        }

        @CustomType.Setter
        public Builder minNodeCount(Integer minNodeCount) {
            this.minNodeCount = Objects.requireNonNull(minNodeCount);
            return this;
        }

        @CustomType.Setter
        public Builder scaleInCooldownSeconds(Double scaleInCooldownSeconds) {
            this.scaleInCooldownSeconds = Objects.requireNonNull(scaleInCooldownSeconds);
            return this;
        }

        @CustomType.Setter
        public Builder scaleOutCooldownSeconds(Double scaleOutCooldownSeconds) {
            this.scaleOutCooldownSeconds = Objects.requireNonNull(scaleOutCooldownSeconds);
            return this;
        }

        public KxClusterAutoScalingConfiguration build() {
            KxClusterAutoScalingConfiguration o = new KxClusterAutoScalingConfiguration();
            o.autoScalingMetric = this.autoScalingMetric;
            o.maxNodeCount = this.maxNodeCount;
            o.metricTarget = this.metricTarget;
            o.minNodeCount = this.minNodeCount;
            o.scaleInCooldownSeconds = this.scaleInCooldownSeconds;
            o.scaleOutCooldownSeconds = this.scaleOutCooldownSeconds;
            return o;
        }
    }
}

