/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.finspace.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@CustomType
public final class KxClusterDatabaseCacheConfiguration {
    private String cacheType;
    @Nullable
    private List<String> dbPaths;

    private KxClusterDatabaseCacheConfiguration() {
    }

    public String cacheType() {
        return this.cacheType;
    }

    public List<String> dbPaths() {
        return this.dbPaths == null ? List.of() : this.dbPaths;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(KxClusterDatabaseCacheConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String cacheType;
        @Nullable
        private List<String> dbPaths;

        public Builder() {
        }

        public Builder(KxClusterDatabaseCacheConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.cacheType = defaults.cacheType;
            this.dbPaths = defaults.dbPaths;
        }

        @CustomType.Setter
        public Builder cacheType(String cacheType) {
            this.cacheType = Objects.requireNonNull(cacheType);
            return this;
        }

        @CustomType.Setter
        public Builder dbPaths(@Nullable List<String> dbPaths) {
            this.dbPaths = dbPaths;
            return this;
        }

        public Builder dbPaths(String ... dbPaths) {
            return this.dbPaths(List.of(dbPaths));
        }

        public KxClusterDatabaseCacheConfiguration build() {
            KxClusterDatabaseCacheConfiguration o = new KxClusterDatabaseCacheConfiguration();
            o.cacheType = this.cacheType;
            o.dbPaths = this.dbPaths;
            return o;
        }
    }
}

