/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.finspace.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;

@CustomType
public final class KxClusterVpcConfiguration {
    private String ipAddressType;
    private List<String> securityGroupIds;
    private List<String> subnetIds;
    private String vpcId;

    private KxClusterVpcConfiguration() {
    }

    public String ipAddressType() {
        return this.ipAddressType;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(KxClusterVpcConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String ipAddressType;
        private List<String> securityGroupIds;
        private List<String> subnetIds;
        private String vpcId;

        public Builder() {
        }

        public Builder(KxClusterVpcConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.ipAddressType = defaults.ipAddressType;
            this.securityGroupIds = defaults.securityGroupIds;
            this.subnetIds = defaults.subnetIds;
            this.vpcId = defaults.vpcId;
        }

        @CustomType.Setter
        public Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = Objects.requireNonNull(ipAddressType);
            return this;
        }

        @CustomType.Setter
        public Builder securityGroupIds(List<String> securityGroupIds) {
            this.securityGroupIds = Objects.requireNonNull(securityGroupIds);
            return this;
        }

        public Builder securityGroupIds(String ... securityGroupIds) {
            return this.securityGroupIds(List.of(securityGroupIds));
        }

        @CustomType.Setter
        public Builder subnetIds(List<String> subnetIds) {
            this.subnetIds = Objects.requireNonNull(subnetIds);
            return this;
        }

        public Builder subnetIds(String ... subnetIds) {
            return this.subnetIds(List.of(subnetIds));
        }

        @CustomType.Setter
        public Builder vpcId(String vpcId) {
            this.vpcId = Objects.requireNonNull(vpcId);
            return this;
        }

        public KxClusterVpcConfiguration build() {
            KxClusterVpcConfiguration o = new KxClusterVpcConfiguration();
            o.ipAddressType = this.ipAddressType;
            o.securityGroupIds = this.securityGroupIds;
            o.subnetIds = this.subnetIds;
            o.vpcId = this.vpcId;
            return o;
        }
    }
}

