/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.fis.outputs;

import com.pulumi.aws.fis.outputs.ExperimentTemplateActionParameter;
import com.pulumi.aws.fis.outputs.ExperimentTemplateActionTarget;
import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ExperimentTemplateAction {
    private String actionId;
    @Nullable
    private String description;
    private String name;
    @Nullable
    private List<ExperimentTemplateActionParameter> parameters;
    @Nullable
    private List<String> startAfters;
    @Nullable
    private ExperimentTemplateActionTarget target;

    private ExperimentTemplateAction() {
    }

    public String actionId() {
        return this.actionId;
    }

    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    public String name() {
        return this.name;
    }

    public List<ExperimentTemplateActionParameter> parameters() {
        return this.parameters == null ? List.of() : this.parameters;
    }

    public List<String> startAfters() {
        return this.startAfters == null ? List.of() : this.startAfters;
    }

    public Optional<ExperimentTemplateActionTarget> target() {
        return Optional.ofNullable(this.target);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ExperimentTemplateAction defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String actionId;
        @Nullable
        private String description;
        private String name;
        @Nullable
        private List<ExperimentTemplateActionParameter> parameters;
        @Nullable
        private List<String> startAfters;
        @Nullable
        private ExperimentTemplateActionTarget target;

        public Builder() {
        }

        public Builder(ExperimentTemplateAction defaults) {
            Objects.requireNonNull(defaults);
            this.actionId = defaults.actionId;
            this.description = defaults.description;
            this.name = defaults.name;
            this.parameters = defaults.parameters;
            this.startAfters = defaults.startAfters;
            this.target = defaults.target;
        }

        @CustomType.Setter
        public Builder actionId(String actionId) {
            this.actionId = Objects.requireNonNull(actionId);
            return this;
        }

        @CustomType.Setter
        public Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @CustomType.Setter
        public Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        @CustomType.Setter
        public Builder parameters(@Nullable List<ExperimentTemplateActionParameter> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder parameters(ExperimentTemplateActionParameter ... parameters) {
            return this.parameters(List.of(parameters));
        }

        @CustomType.Setter
        public Builder startAfters(@Nullable List<String> startAfters) {
            this.startAfters = startAfters;
            return this;
        }

        public Builder startAfters(String ... startAfters) {
            return this.startAfters(List.of(startAfters));
        }

        @CustomType.Setter
        public Builder target(@Nullable ExperimentTemplateActionTarget target) {
            this.target = target;
            return this;
        }

        public ExperimentTemplateAction build() {
            ExperimentTemplateAction o = new ExperimentTemplateAction();
            o.actionId = this.actionId;
            o.description = this.description;
            o.name = this.name;
            o.parameters = this.parameters;
            o.startAfters = this.startAfters;
            o.target = this.target;
            return o;
        }
    }
}

