/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.gamelift.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class BuildStorageLocation {
    private String bucket;
    private String key;
    @Nullable
    private String objectVersion;
    private String roleArn;

    private BuildStorageLocation() {
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public Optional<String> objectVersion() {
        return Optional.ofNullable(this.objectVersion);
    }

    public String roleArn() {
        return this.roleArn;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BuildStorageLocation defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String bucket;
        private String key;
        @Nullable
        private String objectVersion;
        private String roleArn;

        public Builder() {
        }

        public Builder(BuildStorageLocation defaults) {
            Objects.requireNonNull(defaults);
            this.bucket = defaults.bucket;
            this.key = defaults.key;
            this.objectVersion = defaults.objectVersion;
            this.roleArn = defaults.roleArn;
        }

        @CustomType.Setter
        public Builder bucket(String bucket) {
            this.bucket = Objects.requireNonNull(bucket);
            return this;
        }

        @CustomType.Setter
        public Builder key(String key) {
            this.key = Objects.requireNonNull(key);
            return this;
        }

        @CustomType.Setter
        public Builder objectVersion(@Nullable String objectVersion) {
            this.objectVersion = objectVersion;
            return this;
        }

        @CustomType.Setter
        public Builder roleArn(String roleArn) {
            this.roleArn = Objects.requireNonNull(roleArn);
            return this;
        }

        public BuildStorageLocation build() {
            BuildStorageLocation o = new BuildStorageLocation();
            o.bucket = this.bucket;
            o.key = this.key;
            o.objectVersion = this.objectVersion;
            o.roleArn = this.roleArn;
            return o;
        }
    }
}

