/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.gamelift.outputs;

import com.pulumi.aws.gamelift.outputs.FleetRuntimeConfigurationServerProcess;
import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class FleetRuntimeConfiguration {
    @Nullable
    private Integer gameSessionActivationTimeoutSeconds;
    @Nullable
    private Integer maxConcurrentGameSessionActivations;
    @Nullable
    private List<FleetRuntimeConfigurationServerProcess> serverProcesses;

    private FleetRuntimeConfiguration() {
    }

    public Optional<Integer> gameSessionActivationTimeoutSeconds() {
        return Optional.ofNullable(this.gameSessionActivationTimeoutSeconds);
    }

    public Optional<Integer> maxConcurrentGameSessionActivations() {
        return Optional.ofNullable(this.maxConcurrentGameSessionActivations);
    }

    public List<FleetRuntimeConfigurationServerProcess> serverProcesses() {
        return this.serverProcesses == null ? List.of() : this.serverProcesses;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(FleetRuntimeConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Integer gameSessionActivationTimeoutSeconds;
        @Nullable
        private Integer maxConcurrentGameSessionActivations;
        @Nullable
        private List<FleetRuntimeConfigurationServerProcess> serverProcesses;

        public Builder() {
        }

        public Builder(FleetRuntimeConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.gameSessionActivationTimeoutSeconds = defaults.gameSessionActivationTimeoutSeconds;
            this.maxConcurrentGameSessionActivations = defaults.maxConcurrentGameSessionActivations;
            this.serverProcesses = defaults.serverProcesses;
        }

        @CustomType.Setter
        public Builder gameSessionActivationTimeoutSeconds(@Nullable Integer gameSessionActivationTimeoutSeconds) {
            this.gameSessionActivationTimeoutSeconds = gameSessionActivationTimeoutSeconds;
            return this;
        }

        @CustomType.Setter
        public Builder maxConcurrentGameSessionActivations(@Nullable Integer maxConcurrentGameSessionActivations) {
            this.maxConcurrentGameSessionActivations = maxConcurrentGameSessionActivations;
            return this;
        }

        @CustomType.Setter
        public Builder serverProcesses(@Nullable List<FleetRuntimeConfigurationServerProcess> serverProcesses) {
            this.serverProcesses = serverProcesses;
            return this;
        }

        public Builder serverProcesses(FleetRuntimeConfigurationServerProcess ... serverProcesses) {
            return this.serverProcesses(List.of(serverProcesses));
        }

        public FleetRuntimeConfiguration build() {
            FleetRuntimeConfiguration o = new FleetRuntimeConfiguration();
            o.gameSessionActivationTimeoutSeconds = this.gameSessionActivationTimeoutSeconds;
            o.maxConcurrentGameSessionActivations = this.maxConcurrentGameSessionActivations;
            o.serverProcesses = this.serverProcesses;
            return o;
        }
    }
}

