/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.gamelift.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class GameServerGroupInstanceDefinition {
    private String instanceType;
    @Nullable
    private String weightedCapacity;

    private GameServerGroupInstanceDefinition() {
    }

    public String instanceType() {
        return this.instanceType;
    }

    public Optional<String> weightedCapacity() {
        return Optional.ofNullable(this.weightedCapacity);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GameServerGroupInstanceDefinition defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String instanceType;
        @Nullable
        private String weightedCapacity;

        public Builder() {
        }

        public Builder(GameServerGroupInstanceDefinition defaults) {
            Objects.requireNonNull(defaults);
            this.instanceType = defaults.instanceType;
            this.weightedCapacity = defaults.weightedCapacity;
        }

        @CustomType.Setter
        public Builder instanceType(String instanceType) {
            this.instanceType = Objects.requireNonNull(instanceType);
            return this;
        }

        @CustomType.Setter
        public Builder weightedCapacity(@Nullable String weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
            return this;
        }

        public GameServerGroupInstanceDefinition build() {
            GameServerGroupInstanceDefinition o = new GameServerGroupInstanceDefinition();
            o.instanceType = this.instanceType;
            o.weightedCapacity = this.weightedCapacity;
            return o;
        }
    }
}

