/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.globalaccelerator.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class AcceleratorAttributes {
    @Nullable
    private Boolean flowLogsEnabled;
    @Nullable
    private String flowLogsS3Bucket;
    @Nullable
    private String flowLogsS3Prefix;

    private AcceleratorAttributes() {
    }

    public Optional<Boolean> flowLogsEnabled() {
        return Optional.ofNullable(this.flowLogsEnabled);
    }

    public Optional<String> flowLogsS3Bucket() {
        return Optional.ofNullable(this.flowLogsS3Bucket);
    }

    public Optional<String> flowLogsS3Prefix() {
        return Optional.ofNullable(this.flowLogsS3Prefix);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AcceleratorAttributes defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Boolean flowLogsEnabled;
        @Nullable
        private String flowLogsS3Bucket;
        @Nullable
        private String flowLogsS3Prefix;

        public Builder() {
        }

        public Builder(AcceleratorAttributes defaults) {
            Objects.requireNonNull(defaults);
            this.flowLogsEnabled = defaults.flowLogsEnabled;
            this.flowLogsS3Bucket = defaults.flowLogsS3Bucket;
            this.flowLogsS3Prefix = defaults.flowLogsS3Prefix;
        }

        @CustomType.Setter
        public Builder flowLogsEnabled(@Nullable Boolean flowLogsEnabled) {
            this.flowLogsEnabled = flowLogsEnabled;
            return this;
        }

        @CustomType.Setter
        public Builder flowLogsS3Bucket(@Nullable String flowLogsS3Bucket) {
            this.flowLogsS3Bucket = flowLogsS3Bucket;
            return this;
        }

        @CustomType.Setter
        public Builder flowLogsS3Prefix(@Nullable String flowLogsS3Prefix) {
            this.flowLogsS3Prefix = flowLogsS3Prefix;
            return this;
        }

        public AcceleratorAttributes build() {
            AcceleratorAttributes o = new AcceleratorAttributes();
            o.flowLogsEnabled = this.flowLogsEnabled;
            o.flowLogsS3Bucket = this.flowLogsS3Bucket;
            o.flowLogsS3Prefix = this.flowLogsS3Prefix;
            return o;
        }
    }
}

