/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.glue;

import com.pulumi.aws.glue.inputs.PartitionStorageDescriptorArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.resources.ResourceArgs;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class PartitionArgs
extends ResourceArgs {
    public static final PartitionArgs Empty = new PartitionArgs();
    @Import(name="catalogId")
    @Nullable
    private Output<String> catalogId;
    @Import(name="databaseName", required=true)
    private Output<String> databaseName;
    @Import(name="parameters")
    @Nullable
    private Output<Map<String, String>> parameters;
    @Import(name="partitionValues", required=true)
    private Output<List<String>> partitionValues;
    @Import(name="storageDescriptor")
    @Nullable
    private Output<PartitionStorageDescriptorArgs> storageDescriptor;
    @Import(name="tableName", required=true)
    private Output<String> tableName;

    public Optional<Output<String>> catalogId() {
        return Optional.ofNullable(this.catalogId);
    }

    public Output<String> databaseName() {
        return this.databaseName;
    }

    public Optional<Output<Map<String, String>>> parameters() {
        return Optional.ofNullable(this.parameters);
    }

    public Output<List<String>> partitionValues() {
        return this.partitionValues;
    }

    public Optional<Output<PartitionStorageDescriptorArgs>> storageDescriptor() {
        return Optional.ofNullable(this.storageDescriptor);
    }

    public Output<String> tableName() {
        return this.tableName;
    }

    private PartitionArgs() {
    }

    private PartitionArgs(PartitionArgs $) {
        this.catalogId = $.catalogId;
        this.databaseName = $.databaseName;
        this.parameters = $.parameters;
        this.partitionValues = $.partitionValues;
        this.storageDescriptor = $.storageDescriptor;
        this.tableName = $.tableName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PartitionArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private PartitionArgs $;

        public Builder() {
            this.$ = new PartitionArgs();
        }

        public Builder(PartitionArgs defaults) {
            this.$ = new PartitionArgs(Objects.requireNonNull(defaults));
        }

        public Builder catalogId(@Nullable Output<String> catalogId) {
            this.$.catalogId = catalogId;
            return this;
        }

        public Builder catalogId(String catalogId) {
            return this.catalogId((Output<String>)Output.of((Object)catalogId));
        }

        public Builder databaseName(Output<String> databaseName) {
            this.$.databaseName = databaseName;
            return this;
        }

        public Builder databaseName(String databaseName) {
            return this.databaseName((Output<String>)Output.of((Object)databaseName));
        }

        public Builder parameters(@Nullable Output<Map<String, String>> parameters) {
            this.$.parameters = parameters;
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            return this.parameters((Output<Map<String, String>>)Output.of(parameters));
        }

        public Builder partitionValues(Output<List<String>> partitionValues) {
            this.$.partitionValues = partitionValues;
            return this;
        }

        public Builder partitionValues(List<String> partitionValues) {
            return this.partitionValues((Output<List<String>>)Output.of(partitionValues));
        }

        public Builder partitionValues(String ... partitionValues) {
            return this.partitionValues(List.of(partitionValues));
        }

        public Builder storageDescriptor(@Nullable Output<PartitionStorageDescriptorArgs> storageDescriptor) {
            this.$.storageDescriptor = storageDescriptor;
            return this;
        }

        public Builder storageDescriptor(PartitionStorageDescriptorArgs storageDescriptor) {
            return this.storageDescriptor((Output<PartitionStorageDescriptorArgs>)Output.of((Object)((Object)storageDescriptor)));
        }

        public Builder tableName(Output<String> tableName) {
            this.$.tableName = tableName;
            return this;
        }

        public Builder tableName(String tableName) {
            return this.tableName((Output<String>)Output.of((Object)tableName));
        }

        public PartitionArgs build() {
            this.$.databaseName = Objects.requireNonNull(this.$.databaseName, "expected parameter 'databaseName' to be non-null");
            this.$.partitionValues = Objects.requireNonNull(this.$.partitionValues, "expected parameter 'partitionValues' to be non-null");
            this.$.tableName = Objects.requireNonNull(this.$.tableName, "expected parameter 'tableName' to be non-null");
            return this.$;
        }
    }
}

