/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.glue.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class CrawlerCatalogTarget {
    @Nullable
    private String connectionName;
    private String databaseName;
    @Nullable
    private String dlqEventQueueArn;
    @Nullable
    private String eventQueueArn;
    private List<String> tables;

    private CrawlerCatalogTarget() {
    }

    public Optional<String> connectionName() {
        return Optional.ofNullable(this.connectionName);
    }

    public String databaseName() {
        return this.databaseName;
    }

    public Optional<String> dlqEventQueueArn() {
        return Optional.ofNullable(this.dlqEventQueueArn);
    }

    public Optional<String> eventQueueArn() {
        return Optional.ofNullable(this.eventQueueArn);
    }

    public List<String> tables() {
        return this.tables;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CrawlerCatalogTarget defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String connectionName;
        private String databaseName;
        @Nullable
        private String dlqEventQueueArn;
        @Nullable
        private String eventQueueArn;
        private List<String> tables;

        public Builder() {
        }

        public Builder(CrawlerCatalogTarget defaults) {
            Objects.requireNonNull(defaults);
            this.connectionName = defaults.connectionName;
            this.databaseName = defaults.databaseName;
            this.dlqEventQueueArn = defaults.dlqEventQueueArn;
            this.eventQueueArn = defaults.eventQueueArn;
            this.tables = defaults.tables;
        }

        @CustomType.Setter
        public Builder connectionName(@Nullable String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        @CustomType.Setter
        public Builder databaseName(String databaseName) {
            this.databaseName = Objects.requireNonNull(databaseName);
            return this;
        }

        @CustomType.Setter
        public Builder dlqEventQueueArn(@Nullable String dlqEventQueueArn) {
            this.dlqEventQueueArn = dlqEventQueueArn;
            return this;
        }

        @CustomType.Setter
        public Builder eventQueueArn(@Nullable String eventQueueArn) {
            this.eventQueueArn = eventQueueArn;
            return this;
        }

        @CustomType.Setter
        public Builder tables(List<String> tables) {
            this.tables = Objects.requireNonNull(tables);
            return this;
        }

        public Builder tables(String ... tables) {
            return this.tables(List.of(tables));
        }

        public CrawlerCatalogTarget build() {
            CrawlerCatalogTarget o = new CrawlerCatalogTarget();
            o.connectionName = this.connectionName;
            o.databaseName = this.databaseName;
            o.dlqEventQueueArn = this.dlqEventQueueArn;
            o.eventQueueArn = this.eventQueueArn;
            o.tables = this.tables;
            return o;
        }
    }
}

