/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.glue.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class JobCommand {
    @Nullable
    private String name;
    @Nullable
    private String pythonVersion;
    @Nullable
    private String runtime;
    private String scriptLocation;

    private JobCommand() {
    }

    public Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    public Optional<String> pythonVersion() {
        return Optional.ofNullable(this.pythonVersion);
    }

    public Optional<String> runtime() {
        return Optional.ofNullable(this.runtime);
    }

    public String scriptLocation() {
        return this.scriptLocation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(JobCommand defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String name;
        @Nullable
        private String pythonVersion;
        @Nullable
        private String runtime;
        private String scriptLocation;

        public Builder() {
        }

        public Builder(JobCommand defaults) {
            Objects.requireNonNull(defaults);
            this.name = defaults.name;
            this.pythonVersion = defaults.pythonVersion;
            this.runtime = defaults.runtime;
            this.scriptLocation = defaults.scriptLocation;
        }

        @CustomType.Setter
        public Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @CustomType.Setter
        public Builder pythonVersion(@Nullable String pythonVersion) {
            this.pythonVersion = pythonVersion;
            return this;
        }

        @CustomType.Setter
        public Builder runtime(@Nullable String runtime) {
            this.runtime = runtime;
            return this;
        }

        @CustomType.Setter
        public Builder scriptLocation(String scriptLocation) {
            this.scriptLocation = Objects.requireNonNull(scriptLocation);
            return this;
        }

        public JobCommand build() {
            JobCommand o = new JobCommand();
            o.name = this.name;
            o.pythonVersion = this.pythonVersion;
            o.runtime = this.runtime;
            o.scriptLocation = this.scriptLocation;
            return o;
        }
    }
}

