/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.glue.outputs;

import com.pulumi.aws.glue.outputs.TriggerActionNotificationProperty;
import com.pulumi.core.annotations.CustomType;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class TriggerAction {
    @Nullable
    private Map<String, String> arguments;
    @Nullable
    private String crawlerName;
    @Nullable
    private String jobName;
    @Nullable
    private TriggerActionNotificationProperty notificationProperty;
    @Nullable
    private String securityConfiguration;
    @Nullable
    private Integer timeout;

    private TriggerAction() {
    }

    public Map<String, String> arguments() {
        return this.arguments == null ? Map.of() : this.arguments;
    }

    public Optional<String> crawlerName() {
        return Optional.ofNullable(this.crawlerName);
    }

    public Optional<String> jobName() {
        return Optional.ofNullable(this.jobName);
    }

    public Optional<TriggerActionNotificationProperty> notificationProperty() {
        return Optional.ofNullable(this.notificationProperty);
    }

    public Optional<String> securityConfiguration() {
        return Optional.ofNullable(this.securityConfiguration);
    }

    public Optional<Integer> timeout() {
        return Optional.ofNullable(this.timeout);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TriggerAction defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Map<String, String> arguments;
        @Nullable
        private String crawlerName;
        @Nullable
        private String jobName;
        @Nullable
        private TriggerActionNotificationProperty notificationProperty;
        @Nullable
        private String securityConfiguration;
        @Nullable
        private Integer timeout;

        public Builder() {
        }

        public Builder(TriggerAction defaults) {
            Objects.requireNonNull(defaults);
            this.arguments = defaults.arguments;
            this.crawlerName = defaults.crawlerName;
            this.jobName = defaults.jobName;
            this.notificationProperty = defaults.notificationProperty;
            this.securityConfiguration = defaults.securityConfiguration;
            this.timeout = defaults.timeout;
        }

        @CustomType.Setter
        public Builder arguments(@Nullable Map<String, String> arguments) {
            this.arguments = arguments;
            return this;
        }

        @CustomType.Setter
        public Builder crawlerName(@Nullable String crawlerName) {
            this.crawlerName = crawlerName;
            return this;
        }

        @CustomType.Setter
        public Builder jobName(@Nullable String jobName) {
            this.jobName = jobName;
            return this;
        }

        @CustomType.Setter
        public Builder notificationProperty(@Nullable TriggerActionNotificationProperty notificationProperty) {
            this.notificationProperty = notificationProperty;
            return this;
        }

        @CustomType.Setter
        public Builder securityConfiguration(@Nullable String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        @CustomType.Setter
        public Builder timeout(@Nullable Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public TriggerAction build() {
            TriggerAction o = new TriggerAction();
            o.arguments = this.arguments;
            o.crawlerName = this.crawlerName;
            o.jobName = this.jobName;
            o.notificationProperty = this.notificationProperty;
            o.securityConfiguration = this.securityConfiguration;
            o.timeout = this.timeout;
            return o;
        }
    }
}

