/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.imagebuilder;

import com.pulumi.aws.imagebuilder.inputs.ContainerRecipeComponentArgs;
import com.pulumi.aws.imagebuilder.inputs.ContainerRecipeInstanceConfigurationArgs;
import com.pulumi.aws.imagebuilder.inputs.ContainerRecipeTargetRepositoryArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.resources.ResourceArgs;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ContainerRecipeArgs
extends ResourceArgs {
    public static final ContainerRecipeArgs Empty = new ContainerRecipeArgs();
    @Import(name="components", required=true)
    private Output<List<ContainerRecipeComponentArgs>> components;
    @Import(name="containerType", required=true)
    private Output<String> containerType;
    @Import(name="description")
    @Nullable
    private Output<String> description;
    @Import(name="dockerfileTemplateData")
    @Nullable
    private Output<String> dockerfileTemplateData;
    @Import(name="dockerfileTemplateUri")
    @Nullable
    private Output<String> dockerfileTemplateUri;
    @Import(name="instanceConfiguration")
    @Nullable
    private Output<ContainerRecipeInstanceConfigurationArgs> instanceConfiguration;
    @Import(name="kmsKeyId")
    @Nullable
    private Output<String> kmsKeyId;
    @Import(name="name")
    @Nullable
    private Output<String> name;
    @Import(name="parentImage", required=true)
    private Output<String> parentImage;
    @Import(name="platformOverride")
    @Nullable
    private Output<String> platformOverride;
    @Import(name="tags")
    @Nullable
    private Output<Map<String, String>> tags;
    @Import(name="targetRepository", required=true)
    private Output<ContainerRecipeTargetRepositoryArgs> targetRepository;
    @Import(name="version", required=true)
    private Output<String> version;
    @Import(name="workingDirectory")
    @Nullable
    private Output<String> workingDirectory;

    public Output<List<ContainerRecipeComponentArgs>> components() {
        return this.components;
    }

    public Output<String> containerType() {
        return this.containerType;
    }

    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    public Optional<Output<String>> dockerfileTemplateData() {
        return Optional.ofNullable(this.dockerfileTemplateData);
    }

    public Optional<Output<String>> dockerfileTemplateUri() {
        return Optional.ofNullable(this.dockerfileTemplateUri);
    }

    public Optional<Output<ContainerRecipeInstanceConfigurationArgs>> instanceConfiguration() {
        return Optional.ofNullable(this.instanceConfiguration);
    }

    public Optional<Output<String>> kmsKeyId() {
        return Optional.ofNullable(this.kmsKeyId);
    }

    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    public Output<String> parentImage() {
        return this.parentImage;
    }

    public Optional<Output<String>> platformOverride() {
        return Optional.ofNullable(this.platformOverride);
    }

    public Optional<Output<Map<String, String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    public Output<ContainerRecipeTargetRepositoryArgs> targetRepository() {
        return this.targetRepository;
    }

    public Output<String> version() {
        return this.version;
    }

    public Optional<Output<String>> workingDirectory() {
        return Optional.ofNullable(this.workingDirectory);
    }

    private ContainerRecipeArgs() {
    }

    private ContainerRecipeArgs(ContainerRecipeArgs $) {
        this.components = $.components;
        this.containerType = $.containerType;
        this.description = $.description;
        this.dockerfileTemplateData = $.dockerfileTemplateData;
        this.dockerfileTemplateUri = $.dockerfileTemplateUri;
        this.instanceConfiguration = $.instanceConfiguration;
        this.kmsKeyId = $.kmsKeyId;
        this.name = $.name;
        this.parentImage = $.parentImage;
        this.platformOverride = $.platformOverride;
        this.tags = $.tags;
        this.targetRepository = $.targetRepository;
        this.version = $.version;
        this.workingDirectory = $.workingDirectory;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ContainerRecipeArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ContainerRecipeArgs $;

        public Builder() {
            this.$ = new ContainerRecipeArgs();
        }

        public Builder(ContainerRecipeArgs defaults) {
            this.$ = new ContainerRecipeArgs(Objects.requireNonNull(defaults));
        }

        public Builder components(Output<List<ContainerRecipeComponentArgs>> components) {
            this.$.components = components;
            return this;
        }

        public Builder components(List<ContainerRecipeComponentArgs> components) {
            return this.components((Output<List<ContainerRecipeComponentArgs>>)Output.of(components));
        }

        public Builder components(ContainerRecipeComponentArgs ... components) {
            return this.components(List.of(components));
        }

        public Builder containerType(Output<String> containerType) {
            this.$.containerType = containerType;
            return this;
        }

        public Builder containerType(String containerType) {
            return this.containerType((Output<String>)Output.of((Object)containerType));
        }

        public Builder description(@Nullable Output<String> description) {
            this.$.description = description;
            return this;
        }

        public Builder description(String description) {
            return this.description((Output<String>)Output.of((Object)description));
        }

        public Builder dockerfileTemplateData(@Nullable Output<String> dockerfileTemplateData) {
            this.$.dockerfileTemplateData = dockerfileTemplateData;
            return this;
        }

        public Builder dockerfileTemplateData(String dockerfileTemplateData) {
            return this.dockerfileTemplateData((Output<String>)Output.of((Object)dockerfileTemplateData));
        }

        public Builder dockerfileTemplateUri(@Nullable Output<String> dockerfileTemplateUri) {
            this.$.dockerfileTemplateUri = dockerfileTemplateUri;
            return this;
        }

        public Builder dockerfileTemplateUri(String dockerfileTemplateUri) {
            return this.dockerfileTemplateUri((Output<String>)Output.of((Object)dockerfileTemplateUri));
        }

        public Builder instanceConfiguration(@Nullable Output<ContainerRecipeInstanceConfigurationArgs> instanceConfiguration) {
            this.$.instanceConfiguration = instanceConfiguration;
            return this;
        }

        public Builder instanceConfiguration(ContainerRecipeInstanceConfigurationArgs instanceConfiguration) {
            return this.instanceConfiguration((Output<ContainerRecipeInstanceConfigurationArgs>)Output.of((Object)((Object)instanceConfiguration)));
        }

        public Builder kmsKeyId(@Nullable Output<String> kmsKeyId) {
            this.$.kmsKeyId = kmsKeyId;
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            return this.kmsKeyId((Output<String>)Output.of((Object)kmsKeyId));
        }

        public Builder name(@Nullable Output<String> name) {
            this.$.name = name;
            return this;
        }

        public Builder name(String name) {
            return this.name((Output<String>)Output.of((Object)name));
        }

        public Builder parentImage(Output<String> parentImage) {
            this.$.parentImage = parentImage;
            return this;
        }

        public Builder parentImage(String parentImage) {
            return this.parentImage((Output<String>)Output.of((Object)parentImage));
        }

        public Builder platformOverride(@Nullable Output<String> platformOverride) {
            this.$.platformOverride = platformOverride;
            return this;
        }

        public Builder platformOverride(String platformOverride) {
            return this.platformOverride((Output<String>)Output.of((Object)platformOverride));
        }

        public Builder tags(@Nullable Output<Map<String, String>> tags) {
            this.$.tags = tags;
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            return this.tags((Output<Map<String, String>>)Output.of(tags));
        }

        public Builder targetRepository(Output<ContainerRecipeTargetRepositoryArgs> targetRepository) {
            this.$.targetRepository = targetRepository;
            return this;
        }

        public Builder targetRepository(ContainerRecipeTargetRepositoryArgs targetRepository) {
            return this.targetRepository((Output<ContainerRecipeTargetRepositoryArgs>)Output.of((Object)((Object)targetRepository)));
        }

        public Builder version(Output<String> version) {
            this.$.version = version;
            return this;
        }

        public Builder version(String version) {
            return this.version((Output<String>)Output.of((Object)version));
        }

        public Builder workingDirectory(@Nullable Output<String> workingDirectory) {
            this.$.workingDirectory = workingDirectory;
            return this;
        }

        public Builder workingDirectory(String workingDirectory) {
            return this.workingDirectory((Output<String>)Output.of((Object)workingDirectory));
        }

        public ContainerRecipeArgs build() {
            this.$.components = Objects.requireNonNull(this.$.components, "expected parameter 'components' to be non-null");
            this.$.containerType = Objects.requireNonNull(this.$.containerType, "expected parameter 'containerType' to be non-null");
            this.$.parentImage = Objects.requireNonNull(this.$.parentImage, "expected parameter 'parentImage' to be non-null");
            this.$.targetRepository = Objects.requireNonNull(this.$.targetRepository, "expected parameter 'targetRepository' to be non-null");
            this.$.version = Objects.requireNonNull(this.$.version, "expected parameter 'version' to be non-null");
            return this.$;
        }
    }
}

